% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtor.R
\name{filter_hap}
\alias{filter_hap}
\title{Filter hap}
\usage{
filter_hap(hap,
           rm.mode = c("position", "accession", "haplotype", "freq"),
           position.rm = position.rm,
           accession.rm = accession.rm,
           haplotype.rm = haplotype.rm,
           freq.min = 5)
}
\arguments{
\item{hap}{object of hapSummary or hapResult class}

\item{rm.mode}{filter mode, one of "position", "accession", "haplotype"}

\item{position.rm}{numeric vector contains positions need to be removed}

\item{accession.rm}{character vector contains accessions need to be removed,
only hapResult can be filtered by accessions}

\item{haplotype.rm}{character vector contains haplotypes need to be removed}

\item{freq.min}{numeric, hapltypes with accessions number less than freq.min
will be removed}
}
\value{
hapSummary or hapResult depend input
}
\description{
filter hapResult or hapSummary by remove
positions or accessions or haplotypes
}
\examples{
data("geneHapR_test")
hap <- filter_hap(hapResult,
                  rm.mode = c("position", "accession", "haplotype", "freq"),
                  position.rm = c(4879, 4950),
                  accession.rm = c("C1", "C9"),
                  haplotype.rm = c("H009", "H008"),
                  freq.min = 5)
}
