% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textPrepare.R
\name{textPrepare}
\alias{textPrepare}
\title{Preparing text vector for gender prediction}
\usage{
textPrepare(x, textPrepMessages = FALSE)
}
\arguments{
\item{x}{A vector of character strings.}

\item{textPrepMessages}{If TRUE verbose output of the preparing process 
is shown on the console (default is FALSE).}
}
\value{
A vector of unique terms with at least two characters.
}
\description{
The \code{textPrepare} function takes a text vector as an argument 
and converts it into a vector of unique terms. 
This function is used by default 
by the \code{findGivenNames} function
as a text pre-processor before sending a query to the genderize.io API.
}
\examples{

x = c("Winston J. Durant, ASHP past president, dies at 84", 
      "Gold Badge of Honour of the DGAI Prof. Dr. med. Norbert R. Roewer Wuerzburg",
      "The contribution of professor Yu.S. Martynov (1921-2008) to Russian neurology", 
      "JAN BASZKIEWICZ (3 JANUARY 1930 - 27 JANUARY 2011) IN MEMORIAM", 
      "Maria Sklodowska-Curie")

head(textPrepare(x))


}
