% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossCorr.R
\name{crossCorr}
\alias{crossCorr}
\title{Cross Correlations}
\usage{
crossCorr(x, y, by = NULL, by.name = NULL, description = "X vs Y",
  x.var = "X", y.var = "Y", method = "pearson", order.by = "p",
  decreasing = TRUE)
}
\arguments{
\item{x}{A numeric matrix or data frame.}

\item{y}{A second numeric matrix or data frame with the same number of rows
as \code{x}.}

\item{by}{Default is NULL. A grouping vector with length equal to
\code{nrow(x)}. Allows correlation by group (e.g. time).}

\item{by.name}{Default is NULL. String denoting the name of the grouping
factor.}

\item{description}{String giving description of what's being correlated.
Default is "X vs Y".}

\item{x.var}{String denoting type of variables in \code{x}. Default is "X".}

\item{y.var}{String denoting type of variables in \code{y}. Default is "Y".}

\item{method}{Default is set to "pearson". The alternatives are "spearman"
and "kendall".}

\item{order.by}{Order by p-value ("p") or correlation value ("r"). Default is
"p".}

\item{decreasing}{logical. Should the sort be increasing or decreasing?
Default is TRUE.}
}
\value{
\code{corrs} Tall data frame of correlations and p-values.

\code{corr.files} A data frame obtained by \code{cbind(by,x,y)}.

\code{corr.names} A string denoting the description of the variables 
  being correlated.

\code{x.var} String denoting type of variables in \code{x}.

\code{y.var} String denoting type of variables in \code{y}.

\code{corr.method} One of "pearson", "spearman", or "kendall".
}
\description{
Perform pairwise correlations formatted for BART
}
\details{
This function uses the \code{\link[psych]{corr.test}} function in
  the \code{pysch} package to find the correlations and p-values. It then
  formats the results in a tall format for BART.
}
\examples{
# Example data
data(tb.flow)

# Format expression data to align with flow data
gene.data <- data.frame(t(tb.expr[1:100, ]))
rownames(gene.data) <- paste0(tb.design$monkey_id, "_", tb.design$timepoint)
flow.data <- data.frame(t(tb.flow))
flow.data <- flow.data[match(rownames(gene.data), rownames(flow.data), nomatch = 0), ]
gene.data <- gene.data[match(rownames(flow.data), rownames(gene.data), nomatch = 0), ]

# Create time variable
time <- tb.flow.des$timepoint[match(rownames(flow.data),tb.flow.des$columnname,nomatch = 0)]

# Run correlations and format for BART
corrs <- crossCorr(x = gene.data, y = flow.data, by = time, by.name = "days", 
                   description = "Genes vs Flow", x.var = "Genes", 
                   y.var = "Flow", method = "spearman")
}
