/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.parameterization;

import org.apache.commons.math3.random.RandomGenerator;
import org.drugis.common.stat.DichotomousDescriptives;
import org.drugis.common.stat.EstimateWithPrecision;
import org.drugis.common.stat.Statistics;
import org.drugis.mtc.data.DataType;
import org.drugis.mtc.model.Measurement;
import org.drugis.mtc.model.Network;
import org.drugis.mtc.model.Study;
import org.drugis.mtc.model.Treatment;
import org.drugis.mtc.parameterization.AbstractDataStartingValueGenerator;
import org.drugis.mtc.parameterization.BasicParameter;
import org.drugis.mtc.parameterization.NetworkModel;

public class DichotomousDataStartingValueGenerator
extends AbstractDataStartingValueGenerator {
    public DichotomousDataStartingValueGenerator(Network network) {
        super(network, null, 0.0);
        if (!network.getType().equals((Object)DataType.RATE)) {
            throw new IllegalArgumentException("The network must be RATE");
        }
    }

    public DichotomousDataStartingValueGenerator(Network network, RandomGenerator rng, double scale) {
        super(network, rng, scale);
        if (!network.getType().equals((Object)DataType.RATE)) {
            throw new IllegalArgumentException("The network must be RATE");
        }
    }

    protected EstimateWithPrecision estimateTreatmentEffect(Study study, Treatment treatment) {
        Measurement m = NetworkModel.findMeasurement(study, treatment);
        DichotomousDescriptives descriptives = new DichotomousDescriptives(true);
        double mean = descriptives.logOdds(m.getResponders(), m.getSampleSize());
        double se = descriptives.logOddsError(m.getResponders(), m.getSampleSize());
        return new EstimateWithPrecision(mean, se);
    }

    protected EstimateWithPrecision estimateRelativeEffect(Study study, BasicParameter p) {
        Measurement m0 = NetworkModel.findMeasurement(study, p.getBaseline());
        Measurement m1 = NetworkModel.findMeasurement(study, p.getSubject());
        return Statistics.logOddsRatio(m0.getResponders(), m0.getSampleSize(), m1.getResponders(), m1.getSampleSize(), true);
    }
}

