/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.parameterization;

import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.math3.random.RandomGenerator;
import org.drugis.common.stat.EstimateWithPrecision;
import org.drugis.mtc.model.Network;
import org.drugis.mtc.model.Study;
import org.drugis.mtc.model.Treatment;
import org.drugis.mtc.parameterization.BasicParameter;
import org.drugis.mtc.parameterization.ContinuousDataStartingValueGenerator;
import org.drugis.mtc.parameterization.DichotomousDataStartingValueGenerator;
import org.drugis.mtc.parameterization.PriorGenerator;
import org.drugis.mtc.parameterization.StartingValueGenerator;
import org.drugis.mtc.util.DerSimonianLairdPooling;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataStartingValueGenerator
implements StartingValueGenerator {
    protected final Network d_network;
    private final PriorGenerator d_priorGen;
    private final RandomGenerator d_rng;
    private final double d_scale;

    public static StartingValueGenerator create(Network network, RandomGenerator rng, double scale) {
        switch (network.getType()) {
            case CONTINUOUS: {
                return new ContinuousDataStartingValueGenerator(network, rng, scale);
            }
            case RATE: {
                return new DichotomousDataStartingValueGenerator(network, rng, scale);
            }
        }
        throw new IllegalArgumentException("Don't know how to generate starting values for " + (Object)((Object)network.getType()) + " data");
    }

    public AbstractDataStartingValueGenerator(Network network, RandomGenerator rng, double scale) {
        this.d_network = network;
        this.d_priorGen = new PriorGenerator(network);
        this.d_rng = rng;
        this.d_scale = scale;
    }

    protected abstract EstimateWithPrecision estimateRelativeEffect(Study var1, BasicParameter var2);

    protected abstract EstimateWithPrecision estimateTreatmentEffect(Study var1, Treatment var2);

    @Override
    public double getTreatmentEffect(Study study, Treatment treatment) {
        return this.generate(this.estimateTreatmentEffect(study, treatment));
    }

    @Override
    public double getRelativeEffect(Study study, BasicParameter p) {
        return this.generate(this.estimateRelativeEffect(study, p));
    }

    @Override
    public double getRelativeEffect(BasicParameter p) {
        return this.generate(this.getPooledEffect(p));
    }

    @Override
    public double getStandardDeviation() {
        if (this.d_rng == null) {
            return 0.5 * this.d_priorGen.getRandomEffectsSigma();
        }
        return this.d_rng.nextDouble() * this.d_priorGen.getRandomEffectsSigma();
    }

    private EstimateWithPrecision getPooledEffect(BasicParameter p) {
        return new DerSimonianLairdPooling(this.estimateRelativeEffects(p)).getPooled();
    }

    private double generate(EstimateWithPrecision estimate) {
        if (this.d_rng == null) {
            return estimate.getPointEstimate();
        }
        return estimate.getPointEstimate() + this.d_rng.nextGaussian() * this.d_scale * estimate.getStandardError();
    }

    protected List<EstimateWithPrecision> estimateRelativeEffects(BasicParameter p) {
        final Pair<Treatment> treatments = new Pair<Treatment>(p.getBaseline(), p.getSubject());
        HashSet<Study> studies = new HashSet<Study>(this.d_network.getStudies());
        CollectionUtils.filter(studies, new Predicate<Study>(){

            @Override
            public boolean evaluate(Study study) {
                return study.getTreatments().containsAll(treatments);
            }
        });
        ArrayList<EstimateWithPrecision> estimates = new ArrayList<EstimateWithPrecision>(studies.size());
        for (Study s : studies) {
            estimates.add(this.estimateRelativeEffect(s, p));
        }
        return estimates;
    }
}

