/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.model;

import com.jgoodies.binding.beans.Observable;
import com.jgoodies.binding.list.ObservableList;
import java.beans.PropertyChangeListener;
import javax.xml.bind.annotation.XmlTransient;
import org.drugis.common.beans.ObserverManager;
import org.drugis.common.beans.SortedSetModel;
import org.drugis.mtc.data.DataType;
import org.drugis.mtc.data.NetworkData;
import org.drugis.mtc.data.StudyData;
import org.drugis.mtc.data.TreatmentData;
import org.drugis.mtc.model.Study;
import org.drugis.mtc.model.Treatment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Network
extends NetworkData
implements Observable {
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_TYPE = "type";
    @XmlTransient
    ObserverManager d_obsManager = new ObserverManager(this);

    public Network() {
        this.studyList = new SortedStudies();
        this.treatmentList = new SortedTreatments();
    }

    public Network(NetworkData data) {
        this.description = data.getDescription();
        this.type = data.getType();
        this.studyList = new SortedStudies(data.getStudyList());
        this.treatmentList = new SortedTreatments(data.getTreatmentList());
    }

    @Override
    public void setType(DataType newValue) {
        DataType oldValue = super.getType();
        super.setType(newValue);
        this.d_obsManager.firePropertyChange(PROPERTY_TYPE, (Object)oldValue, (Object)newValue);
    }

    @Override
    public void setDescription(String newValue) {
        String oldValue = this.getDescription();
        super.setDescription(newValue);
        this.d_obsManager.firePropertyChange(PROPERTY_DESCRIPTION, oldValue, newValue);
    }

    public ObservableList<Treatment> getTreatments() {
        return (ObservableList)super.getTreatmentList().getTreatment();
    }

    public ObservableList<Study> getStudies() {
        return (ObservableList)super.getStudyList().getStudy();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.d_obsManager.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.d_obsManager.removePropertyChangeListener(listener);
    }

    public Network restrictMeasurements() {
        Network n = new Network();
        n.setDescription(this.getDescription());
        n.setType(this.getType());
        n.setTreatmentList(this.getTreatmentList());
        n.setStudyList(new NetworkData.Studies());
        for (Study s : this.getStudies()) {
            n.getStudies().add(s.restrictMeasurements(this.type));
        }
        return n;
    }

    private static class SortedTreatments
    extends NetworkData.Treatments {
        public SortedTreatments(NetworkData.Treatments treatments) {
            this.treatment = new SortedSetModel<TreatmentData>(treatments.getTreatment());
        }

        public SortedTreatments() {
            this.treatment = new SortedSetModel();
        }
    }

    private static class SortedStudies
    extends NetworkData.Studies {
        public SortedStudies(NetworkData.Studies studies) {
            this.study = new SortedSetModel<StudyData>(studies.getStudy());
        }

        public SortedStudies() {
            this.study = new SortedSetModel();
        }
    }
}

