/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.yadas;

import java.util.Map;
import org.drugis.mtc.MCMCSettings;
import org.drugis.mtc.NodeSplitModel;
import org.drugis.mtc.model.Network;
import org.drugis.mtc.parameterization.BasicParameter;
import org.drugis.mtc.parameterization.NetworkParameter;
import org.drugis.mtc.parameterization.NodeSplitParameterization;
import org.drugis.mtc.parameterization.Parameterization;
import org.drugis.mtc.parameterization.SplitParameter;
import org.drugis.mtc.yadas.Derivation;
import org.drugis.mtc.yadas.YadasModel;

public class YadasNodeSplitModel
extends YadasModel
implements NodeSplitModel {
    private final BasicParameter d_split;

    public YadasNodeSplitModel(Network network, BasicParameter split, MCMCSettings settings) {
        super(network, settings);
        this.d_split = split;
    }

    public YadasNodeSplitModel(Network network, NodeSplitParameterization pmtz, MCMCSettings settings) {
        super(network, pmtz, settings);
        this.d_split = pmtz.getSplitNode();
    }

    @Override
    protected Parameterization buildNetworkModel() {
        return NodeSplitParameterization.create(this.d_network, this.d_split);
    }

    @Override
    protected Map<NetworkParameter, Derivation> getDerivedParameters() {
        Map<NetworkParameter, Derivation> map = super.getDerivedParameters();
        map.put(this.getIndirectEffect(), new Derivation(((NodeSplitParameterization)this.d_pmtz).parameterizeIndirect()));
        return map;
    }

    @Override
    protected boolean isInconsistency() {
        return false;
    }

    @Override
    public NetworkParameter getDirectEffect() {
        return new SplitParameter(this.d_split.getBaseline(), this.d_split.getSubject(), true);
    }

    @Override
    public NetworkParameter getIndirectEffect() {
        return new SplitParameter(this.d_split.getBaseline(), this.d_split.getSubject(), false);
    }

    @Override
    public BasicParameter getSplitNode() {
        return this.d_split;
    }
}

