% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geex.R
\docType{package}
\name{geex-package}
\alias{geex}
\alias{geex-package}
\title{geex: M-estimation API}
\description{
geex provides an extensible API for estimating parameters and their covariance
from a set of estimating functions (M-estimation). M-estimation theory has a
long history [see reference in the M-estimation bibliography:
\url{https://bsaul.github.io/geex/articles/articles/mestimation_bib.html}.
For an excellent introduction, see the primer by L.A. Stefanski and D.D. Boos,
"The Calculus of M-estimation" (The American Statistician (2002), 56(1), 29-38)
(\url{http://www.jstor.org/stable/3087324}).
}
\details{
M-estimation encompasses a broad swath of statistical estimators and ideas including:

\itemize{
\item the empirical "sandwich" variance estimator
\item generalized estimating equations (GEE)
\item many maximum likelihood estimators
\item robust regression
\item and many more}

geex can implement all of these using a user-defined estimating function.

To learn more about geex, see the package vignettes: \code{browseVignettes(package = 'geex')}.
}
\section{Goals}{

If you can specify a set of unbiased estimating equations, geex does the rest.
The goals of geex are simply:

\itemize{
\item To minimize the translational distance between a set of estimating
functions and R code;
\item To return numerically accurate point and covariance estimates from
a set of unbiased estimating functions.
}

geex does not, by itself, necessarily aim to be fast nor precise. Such goals
are left to the user to implement or confirm.
}

\references{
Saul, Bradley C., and Michael G. Hudgens. (2020).
"The Calculus of M-estimation in R with geex." Journal of Statistical Software 92(2), 1-15.
\href{http://dx.doi.org/10.18637/jss.v092.i02}{doi:10.18637/jss.v092.i02}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/bsaul/geex}
  \item \url{https://bsaul.github.io/geex/}
  \item Report bugs at \url{https://github.com/bsaul/geex/issues}
}

}
\author{
\strong{Maintainer}: Bradley Saul \email{bradleysaul@gmail.com}

Other contributors:
\itemize{
  \item Brian Barkley [contributor]
}

}
