% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geessbin.R
\name{geessbin}
\alias{geessbin}
\title{Modified Generalized Estimating Equations for Binary Outcome}
\usage{
geessbin(
  formula,
  data = parent.frame(),
  id = NULL,
  corstr = "independence",
  repeated = NULL,
  beta.method = "PGEE",
  SE.method = "MB",
  b = NULL,
  maxitr = 50,
  tol = 1e-05,
  scale.fix = FALSE,
  conf.level = 0.95
)
}
\arguments{
\item{formula}{Object of class formula: symbolic description of model to be
fitted (see documentation of \code{lm} and
\code{formula} for details).}

\item{data}{Data frame.}

\item{id}{Vector that identifies the subjects or clusters (\code{NULL} by
default).}

\item{corstr}{Working correlation structure. The following are permitted:
"\code{independence}", "\code{exchangeable}", "\code{ar1}", and
"\code{unstructured}" ("\code{independence}" by default).}

\item{repeated}{Vector that identifies repeatedly measured variable within
each subject or cluster. If \code{repeated = NULL}, as is the case in
function \code{gee}, data are assumed to be sorted so that
observations on a cluster are contiguous rows for all entities
in the formula.}

\item{beta.method}{Method for estimating regression parameters (see Details
section). The following are permitted: "\code{GEE}", "\code{PGEE}",
and "\code{BCGEE}" ("\code{PGEE}" by default).}

\item{SE.method}{Method for estimating standard errors (see Details section).
The following are permitted: "\code{SA}", "\code{MK}", "\code{KC}",
"\code{MD}", "\code{FG}", "\code{PA}", "\code{GS}", "\code{MB}",
"\code{WL}", "\code{WB}", "\code{FW}", and "\code{FZ}"
("\code{MB}" by default).}

\item{b}{Numeric vector specifying initial values of regression coefficients.
If \code{b = NULL} (default value), the initial values are calculated
using the ordinary or Firth logistic regression assuming that all the
observations are independent.}

\item{maxitr}{Maximum number of iterations (50 by default).}

\item{tol}{Tolerance used in fitting algorithm (\code{1e-5} by default).}

\item{scale.fix}{Logical variable; if \code{TRUE}, the scale parameter is
fixed at 1 (\code{FALSE} by default).}

\item{conf.level}{Numeric value of confidence level for confidence intervals
(0.95 by default).}
}
\value{
The object of class "\code{geessbin}" representing the results of
modified generalized estimating equations with bias-adjusted covariance
estimators. Generic function \code{summary} provides details of the results.
}
\description{
\code{geessbin} analyzes small-sample clustered or longitudinal data using
modified generalized estimating equations (GEE) with bias-adjusted covariance
estimator. This function assumes binary outcome and uses the logit link
function. This function provides any combination of three GEE methods
(conventional and two modified GEE methods) and 12 covariance estimators
(unadjusted and 11 bias-adjusted estimators).
}
\details{
Details of \code{beta.method} are as follows:
\itemize{
\item "GEE" is the conventional GEE method (Liang and Zeger, 1986)
\item "BCGEE" is the bias-corrected GEE method
      (Paul and Zhang, 2014; Lunardon and Scharfstein, 2017)
\item "PGEE" is the bias reduction of the GEE method obtained by adding a
      Firth-type penalty term to the estimating equation
      (Mondol and Rahman, 2019)
}

Details of \code{SE.method} are as follows:
\itemize{
\item "SA" is the unadjusted sandwich variance estimator
      (Liang and Zeger, 1986)
\item "MK" is the MacKinnon and White estimator (MacKinnon and White, 1985)
\item "KC" is the Kauermann and Carroll estimator
       (Kauermann and Carroll, 2001)
\item "MD" is the Mancl and DeRouen estimator (Mancl and DeRouen, 2001)
\item "FG" is the Fay and Graubard estimator (Fay and Graubard, 2001)
\item "PA" is the Pan estimator (Pan, 2001)
\item "GS" is the Gosho et al. estimator (Gosho et al., 2014)
\item "MB" is the Morel et al. estimator (Morel et al., 2003)
\item "WL" is the Wang and Long estimator (Wang and Long, 2011)
\item "WB" is the Westgate and Burchett estimator
      (Westgate and Burchett, 2016)
\item "FW" is the Ford and Wastgate estimator (Ford and Wastgate, 2018)
\item "FZ" is the Fan et al. estimator (Fan et al., 2013)
}

Descriptions and performances of some of the above methods can be found in
Gosho et al. (2023).
}
\examples{
data(wheeze)

# analysis of PGEE method with Morel et al. covariance estimator
res <- geessbin(formula = Wheeze ~ City + factor(Age), data = wheeze, id = ID,
                corstr = "ar1", repeated = Age, beta.method = "PGEE",
                SE.method = "MB")

# hypothesis tests for regression coefficients
summary(res)

}
\references{
\itemize{
  \item Fan, C., Zhang, D., and Zhang, C. H. (2013). A comparison of
        bias-corrected covariance estimators for generalized estimating
        equations.
        \emph{Journal of Biopharmaceutical Statistics}, 23, 1172–1187,
        \doi{10.1080/10543406.2013.813521}.\cr
  \item Fay, M. P. and Graubard, B. I. (2001). Small-sample adjustments for
        Wald-type tests using sandwich estimators.
        \emph{Biometrics}, 57, 1198–1206,
        \doi{10.1111/j.0006-341X.2001.01198.x}.\cr
  \item Ford, W. P. and Westgate, P. M. (2018). A comparison of
        bias-corrected empirical covariance estimators with generalized
        estimating equations in small-sample longitudinal study settings.
        \emph{Statistics in Medicine}, 37, 4318–4329,
        \doi{10.1002/bimj.201600182}.\cr
  \item Gosho, M., Ishii, R., Noma, H., and Maruo, K. (2023).
        A comparison of bias-adjusted generalized estimating equations for
        sparse binary data in small-sample longitudinal studies.
        \emph{Statistics in Medicine}, 42, 2711–2727,
         \doi{10.1002/sim.9744}.\cr
  \item Gosho, M., Sato, T., and Takeuchi, H. (2014). Robust covariance
        estimator for small-sample adjustment in the generalized estimating
        equations: A simulation study.
        \emph{Science Journal of Applied Mathematics and Statistics},
        2, 20–25,
        \doi{10.11648/j.sjams.20140201.13}.\cr
  \item Kauermann, G. and Carroll, R. J. (2001). A note on the efficiency of
        sandwich covariance matrix estimation.
        \emph{Journal of the American Statistical Association},
        96, 1387–1396,
        \doi{10.1198/016214501753382309}.\cr
  \item Liang, K. and Zeger, S. (1986). Longitudinal data analysis using
        generalized linear models.
        \emph{Biometrika}, 73, 13–22,
        \doi{10.1093/biomet/73.1.13}.\cr
  \item Lunardon, N. and Scharfstein, D. (2017). Comment on ‘Small sample GEE
        estimation of regression parameters for longitudinal data’.
        \emph{Statistics in Medicine}, 36, 3596–3600,
        \doi{10.1002/sim.7366}.\cr
  \item MacKinnon, J. G. and White, H. (1985). Some
        heteroskedasticity-consistent covariance matrix estimators with
        improved finite sample properties.
        \emph{Journal of Econometrics}, 29, 305–325,
        \doi{10.1016/0304-4076(85)90158-7}.\cr
  \item Mancl, L. A. and DeRouen, T. A. (2001). A covariance estimator for
        GEE with improved small-sample properties.
        \emph{Biometrics}, 57, 126–134,
        \doi{10.1111/j.0006-341X.2001.00126.x}.\cr
  \item Mondol, M. H. and Rahman, M. S. (2019). Bias-reduced and
        separation-proof GEE with small or sparse longitudinal binary data.
        \emph{Statistics in Medicine}, 38, 2544–2560,
        \doi{10.1002/sim.8126}.\cr
  \item Morel, J. G., Bokossa, M. C., and Neerchal, N. K. (2003). Small
        sample correlation for the variance of GEE estimators.
        \emph{Biometrical Journal}, 45, 395–409,
        \doi{10.1002/bimj.200390021}.\cr
  \item Pan, W. (2001). On the robust variance estimator in generalised
        estimating equations.
        \emph{Biometrika}, 88, 901–906,
        \doi{10.1093/biomet/88.3.901}.\cr
  \item Paul, S. and Zhang, X. (2014). Small sample GEE estimation of
        regression parameters for longitudinal data.
        \emph{Statistics in Medicine}, 33, 3869–3881,
        \doi{10.1002/sim.6198}.\cr
  \item Wang, M. and Long, Q. (2011). Modified robust variance estimator for
        generalized estimating equations with improved small-sample
        performance.
        \emph{Statistics in Medicine}, 30, 1278–1291,
        \doi{10.1002/sim.4150}.\cr
  \item Westgate, P. M. and Burchett, W. W. (2016). Improving power in
        small-sample longitudinal studies when using generalized estimating
        equations.
        \emph{Statistics in Medicine}, 35, 3733–3744,
        \doi{10.1002/sim.6967}.
}
}
