% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.geolm_cmodStd.R
\name{predict.geolm_cmodStd}
\alias{predict.geolm_cmodStd}
\title{Predict method for geostatistical models}
\usage{
\method{predict}{geolm_cmodStd}(
  object,
  newdata,
  nsim = 0,
  return_type = "SpatialPointsDataFrame",
  dmethod = "chol",
  compute_mspe = TRUE,
  sp = NULL,
  ...
)
}
\arguments{
\item{object}{An object produced by the \code{geolm}
function.}

\item{newdata}{An optional data frame in which to look
for the coordinates at which to predict. If omitted,
the observed data locations are used.}

\item{nsim}{A non-negative integer indicating the number
of realizations to sample at the specified coordinates
using conditional simulation.}

\item{return_type}{A character string indicating the type
of object that should be returned. The default is
\code{"\link[sp]{SpatialPointsDataFrame}"} for easy
plotting of results (see Examples). Other options
include \code{"\link[base]{data.frame}"},
\code{"gearPredict"}, and \code{"\link[sf]{sf}"}.}

\item{dmethod}{The method used to decompose the
covariance matrix for conditional simulation.  Valid
options are \code{"chol"}, \code{"eigen"}, and
\code{"svd"}.  The default is \code{"chol"}.}

\item{compute_mspe}{A logical value indicating whether
the mean square prediction error should be calculated.
Default is \code{TRUE}.}

\item{sp}{This argument will be deprecated in the future.
Please use the \code{return_type} argument. A logical
value indicating whether to object returned should be
of class \code{\link[sp]{SpatialPointsDataFrame}} for
easier plotting with the \code{sp} package.  Default is
\code{TRUE}.}

\item{...}{
  Arguments passed on to \code{\link[=predict.geolm_cmodMan]{predict.geolm_cmodMan}}
  \describe{
    \item{\code{vop}}{The cross-covariance matrix between the
observed responses and the responses to predict.}
    \item{\code{vp}}{The covariance matrix of the responses to
predict.}
  }}
}
\value{
A \code{data.frame},
  \code{SpatialPointsDataFrame}, \code{"gearPredict"}, or
  \code{sf} object with the kriging predictions
  \code{pred}, kriging variance/mean-square prediction
  error (\code{mspe}), the root mean-square prediction
  error \code{mspe} (\code{rmspe}), and the conditional
  simulation \code{sim.1}, \code{sim.2}, etc.
  \code{sim.1}, \code{sim.2}, etc.
}
\description{
\code{predict} calculates the predicted values at specified locations.  The method can additionally provide the mean square prediction error (mspe) and perform conditional simulation.
}
\details{
The \code{newdata} data frame must include the relevant covariates for the prediction locations, where the covariates are specified on the right side of the \code{~} in \code{object$formula}.  \code{newdata} must also include the coordinates of the prediction locations, with these columns having the names provided in \code{object$coordnames}.
}
\examples{
# generate response
y = rnorm(10)
# generate coordinates
x1 = runif(10); x2 = runif(10)

# data frame for observed data
data = data.frame(y, x1, x2)
# newdata must have columns with prediction coordinates
newdata = data.frame(x1 = runif(5), x2 = runif(5))

# specify a standard covariance model
mod = cmod_std(model = "exponential", psill = 1, r = 1)

# geolm for universal kriging
gearmod_uk = geolm(y ~ x1 + x2, data = data, mod = mod,
                   coordnames = c("x1", "x2"))
# prediction for universal kriging, with conditional simulation
pred_uk = predict(gearmod_uk, newdata, nsim = 2)

# geolm for ordinary kriging
gearmod_ok = geolm(y ~ 1, data = data, mod = mod,
                   coordnames = c("x1", "x2"))
# prediction for ordinary kriging
pred_ok = predict(gearmod_ok, newdata)

# geolm for simple kriging
gearmod_sk = geolm(y ~ 1, data = data, mod = mod,
                 coordnames = c("x1", "x2"), mu = 1)
# prediction for simple kriging
pred_sk = predict(gearmod_sk, newdata)
}
\author{
Joshua French
}
