% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ogrinfo}
\alias{ogrinfo}
\title{Retrieve information about a vector data source}
\usage{
ogrinfo(
  dsn,
  layers = NULL,
  cl_arg = as.character(c("-so", "-nomd")),
  open_options = NULL,
  read_only = TRUE,
  cout = TRUE
)
}
\arguments{
\item{dsn}{Character string. Data source name (e.g., filename, database
connection string, etc.)}

\item{layers}{Optional character vector of layer names in the source
dataset.}

\item{cl_arg}{Optional character vector of command-line arguments for
the \code{ogrinfo} command-line utility in GDAL (see URL above for
reference). The default is \code{c("-so", "-nomd")} (see Note).}

\item{open_options}{Optional character vector of dataset open options.}

\item{read_only}{Logical scalar. \code{TRUE} to open the data source read-only
(the default), or \code{FALSE} to open with write access.}

\item{cout}{Logical scalar. \code{TRUE} to write info to the standard C output
stream (the default). \code{FALSE} to suppress console output.}
}
\value{
Invisibly, a character string containing information about the
vector dataset, or empty string (\code{""}) in case of error.
}
\description{
\code{ogrinfo()} is a wrapper of the \command{ogrinfo} command-line
utility (see \url{https://gdal.org/en/stable/programs/ogrinfo.html}).
This function lists information about an OGR-supported data source.
It is also possible to edit data with SQL statements.
Refer to the GDAL documentation at the URL above for a description of
command-line arguments that can be passed in \code{cl_arg}.
Requires GDAL >= 3.7.
}
\note{
The command-line argument \code{-so} provides a summary only, i.e., does not
include details about every single feature of a layer.
\code{-nomd} suppresses metadata printing. Some datasets may contain a lot of
metadata strings.
}
\examples{
\dontshow{if (gdal_version_num() >= gdal_compute_version(3, 7, 0)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
src <- system.file("extdata/ynp_fires_1984_2022.gpkg", package="gdalraster")

# Get the names of the layers in a GeoPackage file
ogrinfo(src)

# Summary of a layer
ogrinfo(src, "mtbs_perims")

# Query an attribute to restrict the output of the features in a layer
args <- c("-ro", "-nomd", "-where", "ig_year = 2020")
ogrinfo(src, "mtbs_perims", args)

# Copy to a temporary in-memory file that is writeable
src_mem <- paste0("/vsimem/", basename(src))
vsi_copy_file(src, src_mem)

# Add a column to a layer
args <- c("-sql", "ALTER TABLE mtbs_perims ADD burn_bnd_ha float")
ogrinfo(src_mem, cl_arg = args, read_only = FALSE)

# Update values of the column with SQL and specify a dialect
sql <- "UPDATE mtbs_perims SET burn_bnd_ha = (burn_bnd_ac / 2.471)"
args <- c("-dialect", "sqlite", "-sql", sql)
ogrinfo(src_mem, cl_arg = args, read_only = FALSE)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=ogr2ogr]{ogr2ogr()}}, \link{ogr_manage}
}
