% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{transform_xy}
\alias{transform_xy}
\title{Transform geospatial x/y coordinates}
\usage{
transform_xy(pts, srs_from, srs_to)
}
\arguments{
\item{pts}{A two-column data frame or numeric matrix containing geospatial
x/y coordinates.}

\item{srs_from}{Character string in OGC WKT format specifying the
spatial reference system for \code{pts}.}

\item{srs_to}{Character string in OGC WKT format specifying the output
spatial reference system.}
}
\value{
Numeric array of geospatial x/y coordinates in the projection
specified by \code{srs_to}.
}
\description{
\code{transform_xy()} transforms geospatial x/y coordinates to a new projection.
}
\examples{
pt_file <- system.file("extdata/storml_pts.csv", package="gdalraster")
pts <- read.csv(pt_file)
print(pts)
## id, x, y in NAD83 / UTM zone 12N
## transform to NAD83 / CONUS Albers
transform_xy(pts = pts[,-1], 
             srs_from = epsg_to_wkt(26912), 
             srs_to = epsg_to_wkt(5070))
}
\seealso{
\code{\link[=epsg_to_wkt]{epsg_to_wkt()}}, \code{\link[=srs_to_wkt]{srs_to_wkt()}}, \code{\link[=inv_project]{inv_project()}}
}
