% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{srs_is_geographic}
\alias{srs_is_geographic}
\title{Check if WKT definition is a geographic coordinate system}
\usage{
srs_is_geographic(srs)
}
\arguments{
\item{srs}{Character OGC WKT string for a spatial reference system}
}
\value{
Logical. \code{TRUE} if \code{srs} is geographic, otherwise \code{FALSE}
}
\description{
\code{srs_is_geographic()} will attempt to import the given WKT string as a
spatial reference system, and returns \code{TRUE}  if the root is a
GEOGCS node. This is a wrapper for \code{OSRIsGeographic()} in the GDAL Spatial
Reference System C API.
}
\examples{
srs_is_geographic(epsg_to_wkt(5070))
srs_is_geographic(srs_to_wkt("WGS84"))
}
\seealso{
\code{\link[=srs_is_projected]{srs_is_projected()}}
}
