% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_collection.R
\name{create_image_collection}
\alias{create_image_collection}
\title{Create an image collection from a set of GDAL datasets or files}
\usage{
create_image_collection(
  files,
  format = NULL,
  out_file = tempfile(fileext = ".sqlite"),
  date_time = NULL,
  band_names = NULL,
  use_subdatasets = FALSE,
  unroll_archives = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{files}{character vector with paths to image files on disk or any GDAL dataset identifiers (including virtual file systems and higher level drivers or GDAL subdatasets)}

\item{format}{collection format, can be either a name to use predefined formats (as output from \code{\link{collection_formats}}) or a path to a custom JSON format description file}

\item{out_file}{optional name of the output SQLite database file, defaults to a temporary file}

\item{date_time}{vector with date/ time for files; can be of class character, Date, or POSIXct (argument is only applicable for image collections without collection format)}

\item{band_names}{character vector with band names, length must match the number of bands in provided files (argument is only applicable for image collections without collection format)}

\item{use_subdatasets}{logical; use GDAL subdatasets of provided files (argument is only applicable for image collections without collection format)}

\item{unroll_archives}{automatically convert .zip, .tar archives and .gz compressed files to GDAL virtual file system dataset identifiers (e.g. by prepending /vsizip/) and add contained files to the list of considered files}

\item{quiet}{logical; if TRUE, do not print resulting image collection if return value is not assigned to a variable}
}
\value{
image collection proxy object, which can be used to create a data cube using \code{\link{raster_cube}}
}
\description{
This function iterates over files or GDAL dataset identifiers and extracts datetime, image identifiers, and band information according to a given
collection format.
}
\details{
An image collection is a simple SQLite database file that indexes and references existing image files / GDAL dataset identifiers.

Collections can be created in two different ways: First, if a collection format is specified (argument \code{format}), date/time, bands, and metadata are automatically
extracted from provided files / GDAL datasets. Second, image collections can be created without collection format by manually specifying date/time of images 
(argument \code{date_time}) and (optional) names of bands. In this case, however, all provided images must contain the same bands. If this is not 
possible for a dataset, a collection format must be used.
}
\examples{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db")) 
}
}
