% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbm.mapsf.R
\name{gbm.mapsf}
\alias{gbm.mapsf}
\title{Maps of predicted abundance from Boosted Regression Tree modelling}
\usage{
gbm.mapsf(
  predabund = NULL,
  predabundlon = 2,
  predabundlat = 1,
  predabundpreds = 3,
  myLocation = NULL,
  trim = TRUE,
  trimfivepct = FALSE,
  scale100 = FALSE,
  gmapsAPI = NULL,
  mapsource = "google",
  googlemap = TRUE,
  maptype = "satellite",
  darkenproportion = 0,
  mapzoom = NULL,
  shape = NULL,
  expandfactor = 0,
  colourscale = "viridis",
  colorscale = NULL,
  heatcolours = c("white", "yellow", "orange", "red", "brown4"),
  colournumber = 8,
  colourscalelimits = NULL,
  colourscalebreaks = NULL,
  colourscalelabels = NULL,
  colourscaleexpand = NULL,
  studyspecies = "MySpecies",
  plottitle = paste0("Predicted abundance of ", studyspecies),
  plotsubtitle = "CPUE",
  legendtitle = "CPUE",
  plotcaption = paste0("gbm.auto::gbm.mapsf, ", lubridate::today()),
  axisxlabel = "Longitude",
  axisylabel = "Latitude",
  legendposition = c(0.05, 0.15),
  fontsize = 12,
  fontfamily = "Times New Roman",
  filesavename = paste0(lubridate::today(), "_", studyspecies, "_", legendtitle, ".png"),
  savedir = tempdir(),
  receiverlats = NULL,
  receiverlons = NULL,
  receivernames = NULL,
  receiverrange = NULL,
  recpointscol = "black",
  recpointsfill = "white",
  recpointsalpha = 0.5,
  recpointssize = 1,
  recpointsshape = 21,
  recbufcol = "grey75",
  recbuffill = "grey",
  recbufalpha = 0.5,
  reclabcol = "black",
  reclabfill = NA,
  reclabnudgex = 0,
  reclabnudgey = -200,
  reclabpad = 0,
  reclabrad = 0.15,
  reclabbord = 0
)
}
\arguments{
\item{predabund}{Predicted abundance data frame produced by gbm.auto (Abundance_Preds_only.csv),
with Latitude, Longitude, and Predicted Abundance columns. Default NULL. You need to read the csv
in R if not already present as an object in the environment.}

\item{predabundlon}{Longitude column number. Default 2.}

\item{predabundlat}{Latitude column number. Default 1.}

\item{predabundpreds}{Predicted abundance column number, default 3.}

\item{myLocation}{Location for extents, format c(xmin, ymin, xmax, ymax). Default NULL, extents
autocreated from data.}

\item{trim}{Remove NA & <=0 values and crop to remaining date extents? Default TRUE.}

\item{trimfivepct}{Replace anything < 5\% of the max value (i.e. < 95\% UD contour in home range
analysis) with NA since it won't be drawn (for movegroup dBBMMs). Default FALSE.}

\item{scale100}{Scale Predicted Abundance to 100? Default FALSE.}

\item{gmapsAPI}{Enter your Google maps API here, quoted character string. Default NULL.}

\item{mapsource}{Source for ggmap::get_map; uses Stamen as fallback if no Google Maps API present
. Options: "google", "stamen", "gbm.basemap". Default "google". Using "gbm.basemap" requires one
to have run that functiuon already, and enter its location using the shape paramater below.}

\item{googlemap}{If pulling basemap from Google maps, this sets expansion factors since Google
Maps tiling zoom setup doesn't align to myLocation extents. Default TRUE.}

\item{maptype}{Type of map for ggmap::get_map param maptype. Options: Google mapsource: "terrain",
"terrain-background", "satellite", "roadmap", "hybrid". Stamen mapsource: "terrain",
"terrain-background", "terrain-labels", "terrain-lines", "watercolor", "toner", "toner-2010",
"toner-2011", "toner-background", "toner-hybrid", "toner-labels", "toner-lines", "toner-lite".}

\item{darkenproportion}{Amount to darken the google/stamen basemap, 0-1. Default 0.}

\item{mapzoom}{Highest number = zoomed in. Google: 3 (continent) - 21 (building). stamen: 0-18.
Default 9.}

\item{shape}{If mapsource is "gbm.basemap", enter the full path to gbm.basemaps downloaded map,
typically Crop_Map.shp, including the .shp. Default NULL. Can also name an existing object in the
environment, read in with sf::st_read.}

\item{expandfactor}{Extents expansion factor for basemap. default 0.}

\item{colourscale}{Scale fill colour scheme to use, default "viridis", other option is
"gradient".}

\item{colorscale}{Scale fill colour scheme to use, default NULL, populating this will overwrite
colourscale.}

\item{heatcolours}{Vector of colours if gradient selected for colourscale, defaults to heatmap
theme.}

\item{colournumber}{Number of colours to spread heatcolours over, if gradient selected for
colourscale. Default 8.}

\item{colourscalelimits}{Colour scale limits, default NULL, vector of 2, e.g. c(0, 0).}

\item{colourscalebreaks}{Colour scale breaks, default NULL.}

\item{colourscalelabels}{Colour scale labels, default NULL, must match number of breaks.}

\item{colourscaleexpand}{Colour scale expand, default NULL, vector of 2, e.g. c(0, 0).}

\item{studyspecies}{Name of your study species, appears in plot title and savename. Default
"MySpecies".}

\item{plottitle}{Title of the resultant plot, default paste0("Predicted abundance of ",
studyspecies).}

\item{plotsubtitle}{Plot subtitle, default ""CPUE". Can add the n of your individuals.}

\item{legendtitle}{Legend title, default "CPUE".}

\item{plotcaption}{Plot caption, default "gbm.auto::gbm.mapsf" + today's date.}

\item{axisxlabel}{Default "Longitude".}

\item{axisylabel}{Default "Latitude".}

\item{legendposition}{Vector of 2, format c(1,2), Proportional distance of (middle?) of legend
box from L to R, percent distance from Bottom to Top. Values 0 to 1. Default c(0.05, 0.15).}

\item{fontsize}{Font size, default 12.}

\item{fontfamily}{= Font family, default "Times New Roman".}

\item{filesavename}{File savename, default today's date + studyspecies + legendtitle.}

\item{savedir}{Save outputs to a temporary directory (default) else change to current directory
e.g. "/home/me/folder". Do not use getwd() here. No terminal slash. E.g.
paste0(movegroupsavedir, "Plot/") .}

\item{receiverlats}{Vector of latitudes for receivers to be plotted.}

\item{receiverlons}{Vector of longitudes for receivers to be plotted. Same length as receiverlats.}

\item{receivernames}{Vector of names for receivers to be plotted. Same length as receiverlats.}

\item{receiverrange}{Single (will be recycled), or vector (same length as receiverlats) of
detection ranges in metres for receivers to be plotted. If you have a max and a (e.g.) 90 percent
detection range, probably use max.}

\item{recpointscol}{Colour of receiver centrepoint outlines. Default "black".}

\item{recpointsfill}{Colour of receiver centrepoint fills. Default "white".}

\item{recpointsalpha}{Alpha value of receiver centrepoint fills, 0 (invisible) to 1 (fully
visible). Default 0.5.}

\item{recpointssize}{Size of receiver points. Default 1.}

\item{recpointsshape}{Shape of receiver points, default 21, circle with outline and fill.}

\item{recbufcol}{Colour of the receiver buffer circle outlines. Default "grey75"}

\item{recbuffill}{Colour of the receiver buffer circle fills. Default "grey".}

\item{recbufalpha}{Alpha value of receiver buffer fills, 0 (invisible) to 1 (fully visible).
Default 0.5.}

\item{reclabcol}{Receiver label text colour. Default "black".}

\item{reclabfill}{Receiver label fill colour, NA for no fill. Default NA.}

\item{reclabnudgex}{Receiver label offset nudge in X dimension. Default 0.}

\item{reclabnudgey}{Receiver label offset nudge in Y dimension. Default -200.}

\item{reclabpad}{Receiver label padding in lines. Default 0.}

\item{reclabrad}{Receiver label radius in lines. Default 0.15.}

\item{reclabbord}{Receiver label border in mm. Default 0.}
}
\value{
Species abundance maps using data provided by gbm.auto, and
Representativeness Surface Builder maps using data provided by gbm.rsb, to be
run in a png/par/gbm.map/dev.off sequence.
}
\description{
Generates maps from the outputs of gbm.step then Gbm.predict.grids, handled automatically within
gbm.auto but can be run alone, and generates representativeness surfaces from the output of
gbm.rsb.
}
\details{
Error in seq.default(xlim[1], xlim[2], by = byx):wrong sign in 'by' argument
Check that your lat & long columns are the right way around. Ensure grids (predabund) data are
gridded, i.e. they are in a regular pattern of same/similar lines of lat/lon, even if they're
missing sections.

Suggested parameter values:
z = rsbdf[,"Unrepresentativeness"]

mapmain = "Unrepresentativeness: "

legendtitle = "UnRep 0-1"
\subsection{How to get Google map basemaps}{

(from https://www.youtube.com/watch?v=O5cUoVpVUjU):
\enumerate{
\item Sign up with dev console: a. You must enter credit card details, but won’t be charged if your
daily API requests stay under the limit. b. Follow the link:
https://console.cloud.google.com/projectselector2/apis/dashboard?supportedpurview=project c.
Sign up for Google cloud account (it may auto populate your current gmail), click agree and
continue. d. Click the navigation email in the top left corner and click on Billing. e. Create a
billing account – they will NOT auto charge after trial ends. f. Enter information, click on
'start my free trial'. They may offer a free credit for trying out their service. More pricing
details: https://mapsplatform.google.com/pricing/ . g. Click “Select a Project” then
“New project” in the top right corner. h. Enter Project Name, leave Location as is, click
“Create”. i. You should now see your project name at the top, where the drop-down menu is.
\item Enable Maps and Places API: a. Click 'Library' on the left. b. In the search field type “Maps”
. c. Scroll down, click “Maps Java Script API”. d. Click Enable. e. Click 'Library' again, search
“Places”, click on “Places API”. f. Click Enable.
\item Create Credentials for API  Key: a. Return to 'APIs & Services' page. b. Click on Credentials.
c. At the top click 'Create Credentials > API Key'. d. API key should pop up with option to copy
it. e. You can restrict the key if you want by following steps 4 & 5 here:
https://www.youtube.com/watch?v=O5cUoVpVUjU&t=232s
}
}
}
\examples{
\donttest{
# Not run
}
}
\author{
Simon Dedman, \email{simondedman@gmail.com}
}
