% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbm.map.R
\name{gbm.map}
\alias{gbm.map}
\title{Maps of predicted abundance from Boosted Regression Tree modelling}
\usage{
gbm.map(
  x,
  y,
  z,
  byx = NULL,
  byy = NULL,
  grdfun = mean,
  mapmain = "Predicted CPUE (numbers per hour): ",
  species = "Response Variable",
  heatcolours = c("white", "yellow", "orange", "red", "brown4"),
  colournumber = 8,
  shape = NULL,
  landcol = "grey80",
  mapback = "lightblue",
  legendloc = "bottomright",
  legendtitle = "CPUE",
  lejback = "white",
  zero = TRUE,
  quantile = 1,
  byxout = FALSE,
  breaks = NULL,
  byxport = NULL,
  ...
)
}
\arguments{
\item{x}{Vector of longitudes, from make.grid in mapplots; x. Order by this
(descending) SECOND.}

\item{y}{Vector of latitudes, from make.grid in mapplots; grids[,gridslat].
Order by this (descending) first.}

\item{z}{Vector of abundances generated by gbm.predict.grids, from make.grid
in mapplots; grids[,predabund].}

\item{byx}{Longitudinal width of grid cell, from make.grid in mapplots.
Autogenerated if left blank.}

\item{byy}{Latitudinal height of grid cell, from make.grid in mapplots.
Autogenerated if left blank.}

\item{grdfun}{make.grid operand for >=2 values per cell. Default:mean, other
options: sum prod min max sd se var.}

\item{mapmain}{Plot title, has species value appended. Default "Predicted
CPUE (numbers per hour): ".}

\item{species}{Response variable name, from basemap in mapplots;
names(samples[i]). Defaults to "Response Variable".}

\item{heatcolours}{Vector for abundance colour scale, defaults to the heatcol from
legend.grid and draw.grid in mapplots which is c("white", "yellow", "orange"
, "red", "brown4").}

\item{colournumber}{Number of colours to spread heatcol over, default:8.}

\item{shape}{Basemap shape to draw, from draw.shape in mapplots. Defaults to
NULL which calls gbm.basemap to generate it for you.}

\item{landcol}{Colour for 'null' area of map (for marine plots, this is
land), from draw.shape in mapplots. Default "grey80" (light grey).}

\item{mapback}{Basemap background colour, defaults to lightblue (ocean for
marine plots).}

\item{legendloc}{Location on map of legend box, from legend.grid in mapplots,
default bottomright.}

\item{legendtitle}{The metric of abundance, e.g. CPUE for fisheries, from
legend.grid in mapplots. Default "CPUE".}

\item{lejback}{Background colour of legend, from legend.grid in mapplots.
Default "white".}

\item{zero}{Force include 0-only bin in breaks.grid and thus legend? Default
TRUE.}

\item{quantile}{Set max quantile of data to include in bins, from breaks.grid
in mapplots; lower to e.g. 0.975 cutoff outliers; default 1.}

\item{byxout}{Export byx to use elsewhere? Default:FALSE.}

\item{breaks}{Vector of breakpoints for colour scales; default blank,
generated automatically.}

\item{byxport}{Dummy param for package testing for CRAN, ignore.}

\item{...}{Additional arguments for legend.grid's ... which passes to legend.}
}
\value{
Species abundance maps using data provided by gbm.auto, and
Representativeness Surface Builder maps using data provided by gbm.rsb, to be
run in a png/par/gbm.map/dev.off sequence.
}
\description{
Generates maps from the outputs of gbm.step then Gbm.predict.grids, handled
automatically within gbm.auto but can be run alone, and generates
representativeness surfaces from the output of gbm.rsb.
}
\details{
Errors and their origins:
Error in seq.default(xlim[1], xlim[2], by = byx):wrong sign in 'by' argument
Check that your lat & long columns are the right way around. Ensure grids
data are gridded.
Suggested parameter values:
z = rsbdf[,"Unrepresentativeness"]
mapmain = "Unrepresentativeness: "
legendtitle = "UnRep 0-1"
}
\examples{
\donttest{
# Not run: downloads and saves external data.
# Suggested code for outputting to png:
data(grids)
# set working directory somewhere suitable
png(filename = "gbmmap.png", width = 7680, height = 7680, units = "px",
pointsize = 192, bg = "white", res = NA, family = "", type = "cairo-png")
par(mar = c(3.2,3,1.3,0), las = 1, mgp = c(2.1,0.5,0), xpd = FALSE)
gbm.map(x = grids[,"Longitude"], y = grids[,"Latitude"], z = grids[,"Effort"]
, species = "Effort")
dev.off()
}
}
\author{
Simon Dedman, \email{simondedman@gmail.com}

Hans Gerritsen
}
