% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_graph.R
\name{download_graph}
\alias{download_graph}
\title{Download sparse matrix form the SuiteSparse Matrix Collection.}
\usage{
download_graph(matrixname, groupname)
}
\arguments{
\item{matrixname}{Name of the graph to download.}

\item{groupname}{Name of the group that provides the graph.}
}
\value{
\code{matrixname} a list contening the sparse matrix \code{sA}, \code{xy} coordinates (if any), \code{dim} the number of rows, columns and numerically nonzero elements  and \code{info}, the path to a plain txt file containing information associated with \code{sA} (accessible for example via \code{file.show(matrixname$info)}).
}
\description{
If coordinates are associated with the graphs,
they are automatically downloaded and added to the output. See \url{https://sparse.tamu.edu/} for the list of groups and graph names.
}
\examples{
\dontrun{
matrixname <- "grid1"
groupname <- "AG-Monien"
download_graph(matrixname,groupname)
file.show(grid1$info)
}
}
\references{
Davis, T. A., & Hu, Y. (2011). The University of Florida sparse matrix collection. ACM Transactions on Mathematical Software (TOMS), 38(1), 1-25.
}
