% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randsignal.R
\name{randsignal}
\alias{randsignal}
\title{Generate random signal with varying regularity.}
\usage{
randsignal(eta, k, A, r)
}
\arguments{
\item{eta}{Smoothness parameter.}

\item{k}{Smoothness parameter.}

\item{A}{Adjacency matrix.}

\item{r}{Optional argument corresponding to the largest eigenvalue (in magnitude), avoids the need to calculate the full spectrum.}
}
\value{
\code{f} output signal.
}
\description{
Generate \eqn{f = A^k x_eta / r^k}{f = A^k * x_eta / r^k},
with A the adjacency matrix and
x_eta realization of Bernoulli random variables of parameter eta and r the largest eigenvalue (in magnitude). The generation is carried out in sparse matrices in order to scale up.
}
