% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_ciras4.R
\name{read_ciras4}
\alias{read_ciras4}
\title{Reads CIRAS-4 csv files and creates a tibble with gas-exchange data}
\usage{
read_ciras4(filename)
}
\arguments{
\item{filename}{a csv file containing gas-exchange data.}
}
\value{
a tibble with gas-exchange data in columns.
}
\description{
The csv files stored by the CIRAS-4 contain measured and calculated values
that are read by this function and formatted in a large tibble for use with
R. Note that no recalculation of derived variables are performed, although it
is possible to do so using \code{\link[=recalculate]{recalculate()}} after importing the data.
}
\details{
Multiple files can be loaded by calling the function with \code{\link[=lapply]{lapply()}} or
\code{\link[purrr:map]{purrr::map()}} to merge multiple files. In this case, it is important
to ensure that the column names will match.
}
\examples{
example <- system.file("extdata//ciras4.csv", package = "gasanalyzer")

# Read using unified column names:
cir4 <- read_ciras4(example)

# Recalculate data using default gas exchange equations:
cir4_recalc <- recalculate(cir4, create_equations(c("default", "ciras4")))

# View differences:
all.equal(cir4, cir4_recalc[names(cir4)], tol = 0.001)
}
\seealso{
\code{\link[=recalculate]{recalculate()}}
}
