% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{dim.garray}
\alias{dim.garray}
\alias{dim}
\alias{dim<-}
\alias{dim<-.garray}
\title{Dimensions of a generalized array}
\usage{
\method{dim}{garray}(x)

\method{dim}{garray}(x) <- value
}
\arguments{
\item{x}{An generalized array.}

\item{value}{An integer (can be coerced from double numeric) vector, with
names.}
}
\description{
Retrieve or set the dimension of a generalized array.
}
\details{
The functions \code{dim} and \code{dim<-} are internal generic primitive functions.
Here \code{dim.garray} and \code{dim<-.garray} are methods for 'garray's, which
returns and setting with the named dimensions (margins).  The two
function is usually used as, for example, \code{dim(arr)} and
\code{dim(arr) <- c(A=3,B=2)}.
Native R saves the names of dim but seldom uses it.  However, it is
undocumented and not stable because some functions
discard it (like: t()) .  This package will totally neglect it but
keeps the margins in dimnames.
}
