% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semipara.R
\name{extract_arma}
\alias{extract_arma}
\title{Extract underlying ARMA process.}
\usage{
extract_arma(x, ggbr_factors)
}
\arguments{
\item{x}{(num) This should be a numeric vector representing the Gegenbauer process.}

\item{ggbr_factors}{(class) Each element of the list represents a Gegenbauer factor and includes f, u and fd elements.}
}
\value{
An object of same class as x.
}
\description{
For a Gegenbauer process, transform to remove Gegenbauer long memory component to get a short memory (ARMA) process.
}
\examples{
data(AirPassengers)
ap <- as.numeric(diff(AirPassengers,12))
# find semiparametric estimates of the Gegenbauer parameters.
sp <- ggbr_semipara(ap)
# extract the underlying short-memory ARMA process
ap_arma <- extract_arma(ap,sp$ggbr_factors)
summary(arima(ap_arma,order=c(1,0,0)))
}
