% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast.R
\name{forecast.garma_model}
\alias{forecast.garma_model}
\title{Forecast future values.}
\usage{
\method{forecast}{garma_model}(object, h = 1, newdata = NULL, ...)
}
\arguments{
\item{object}{(garma_model) The garma_model from which to forecast the values.}

\item{h}{(int) The number of time periods to predict ahead. Default: 1}

\item{newdata}{(real vector or matrix) If the original model was fitted with the 'xreg=' option then this will provide the xreg
  values for predictions. If this is a vector then its length should be 'h'; if it is a matrix then it should have 'h' rows.

  It should have columns with the same names as the original xreg matrix.}

\item{...}{Other parameters passed to the forecast function. For "garma_model" objects, these are ignored.}
}
\value{
- a "ts" object containing the requested forecasts.
}
\description{
The forecast function predicts future values of a "garma_model" object, and is exactly the same as the "predict" function with slightly different parameter values.
}
\examples{
library(forecast)

data(AirPassengers)
ap <- as.numeric(diff(AirPassengers, 12))
mdl <- garma(ap, order = c(9, 1, 0), k = 0, method = "CSS", include.mean = FALSE)
forecast(mdl, h = 12)
}
