% Generated by roxygen2 (4.0.1): do not edit by hand
\name{calculate_gap}
\alias{calculate_gap}
\title{Calculate the gaps based on distance}
\usage{
calculate_gap(d, sum, gap_total, mode = c("quantitative", "threshold"),
  mapping = c("exponential", "linear"), scale = 0.2, max_height = 0,
  threshold = 2, gap_size = 0, verbose = FALSE, ...)
}
\arguments{
\item{d}{dendrogram class object}

\item{sum}{the sum of distance}

\item{gap_total}{the total width allocated for gaps}

\item{mode}{gap mode, either "threshold" or "quantitative"}

\item{mapping}{in case of quantitative mode, either "linear" or "exponential" mapping}

\item{scale}{the sclae log base for the exponential mapping}

\item{max_height}{the highest distance value, which is the value of the first dendrogram branch}

\item{threshold}{the threshold value for threshold mode}

\item{gap_size}{the size of gap for threshold mode}

\item{verbose}{logical for whether in verbose mode or not}

\item{...}{ignored}
}
\value{
the annotated dendrogram class object
}
\description{
This function takes a dendrogram class object and other attributes to calcuate the
size of gaps between leaves. The gap is stored in a  leaf to its left. The function
is called recursively.
}
\keyword{internal}

