% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Segment-generics.R, R/Segment-methods.R
\docType{methods}
\name{PerUser}
\alias{PerUser}
\alias{PerUser,ANY-method}
\alias{PerUser,gaSegmentSequenceStep-method}
\alias{PerUser,gaSegmentSequenceFilter-method}
\alias{PerUser,gaMetExpr-method}
\alias{PerUser,formula-method}
\title{PerUser}
\usage{
PerUser(object, ..., negation)

\S4method{PerUser}{ANY}(object, ..., negation)

\S4method{PerUser}{gaSegmentSequenceStep}(object, ..., negation)

\S4method{PerUser}{gaSegmentSequenceFilter}(object, ..., negation)

\S4method{PerUser}{gaMetExpr}(object, ..., negation)

\S4method{PerUser}{formula}(object, ..., negation)
}
\arguments{
\item{object}{a \code{.gaSegmentFilter} or \code{gaMetExpr} object to coerce to
user-level. Alternatively, an dimension expression or segment filter to
coerce into a user scoped \code{gaDynSegment}.}

\item{...}{Other filters to include in the \code{gaDynSegment}.}

\item{negation}{Boolean value indicating whether to negate the condition.}
}
\value{
A \code{gaMetExpr}, \code{.gaSegmentFilter} or \code{gaDynSegment}.
}
\description{
Set the scope of a \code{.gaSegmentFilter} or \code{gaMetExpr} object to user-level.
}
\section{Methods (by class)}{
\itemize{
\item \code{ANY}: Create a user-level segment filter list from the supplied
expressions, each interpreted as an include segment filter.

\item \code{gaSegmentSequenceStep}: Create a user-level segment sequence filter from the supplied
sequence expression.

\item \code{gaSegmentSequenceFilter}: Create a user-level segment sequence filter from the supplied
sequence expression.

\item \code{gaMetExpr}: Set the scope of the supplied metric condition to
user-level.

\item \code{formula}: Set the scope of the supplied non-standard-evaluation
metric condition to user-level.
}}

\note{
To define a \code{gaDynSegment} comprised of a single metric expression,
wrap the metric expression in an \code{Include} or \code{Exclude} call.
}
\examples{
spent_more_than_100_per_user <- PerUser(Expr(~transactionRevenue > 100))

}
\seealso{
Other dynamic segment functions: \code{\link{DynSegment}},
  \code{\link{Exclude}}, \code{\link{Include}},
  \code{\link{IsNegated}}, \code{\link{PerHit}},
  \code{\link{PerProduct}}, \code{\link{PerSession}},
  \code{\link{ScopeLevel}},
  \code{\link{SegmentConditionFilter}},
  \code{\link{Segments}}, \code{\link{Segment}}
}
\concept{dynamic segment functions}
