% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Segment-generics.R, R/Segment-methods.R
\docType{methods}
\name{PerHit}
\alias{PerHit}
\alias{PerHit,.compoundExpr-method}
\alias{PerHit,gaMetExpr-method}
\alias{PerHit,formula-method}
\title{PerHit.}
\usage{
PerHit(object, ..., negation)

\S4method{PerHit}{.compoundExpr}(object, ..., negation)

\S4method{PerHit}{gaMetExpr}(object, ..., negation)

\S4method{PerHit}{formula}(object, ..., negation)
}
\arguments{
\item{object}{a gaMetExpr object to coerce to hit-level or if multiple
expressions are provided, then the first expression to combine into a
single step of sequence filter.}

\item{...}{Further expressions to be included in the filter definition if
defining a sequence filter of length one.}

\item{negation}{boolean value indicating whether to negate the condition.}
}
\value{
a gaMetExpr or gaSegmentSequenceFilter.
}
\description{
Set the scope of a gaMetExpr object to hit-level, or transforms a condition
filter to a sequence filter of length one (i.e. a combination of conditions
for matching a single hit).
}
\section{Methods (by class)}{
\itemize{
\item \code{.compoundExpr}: Create a single step sequence filter from the supplied
expression.

\item \code{gaMetExpr}: Set the scope of the supplied metric condition to
hit-level.

\item \code{formula}: Set the scope of the supplied non-standard-evaluation
metric condition to hit-level.
}}

