% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_group_by.R
\name{group_by.data_request}
\alias{group_by.data_request}
\alias{galah_group_by}
\title{Group by one or more variables}
\usage{
\method{group_by}{data_request}(.data, ...)

galah_group_by(...)
}
\arguments{
\item{.data}{An object of class \code{data_request}}

\item{...}{Zero or more individual column names to include}
}
\value{
If any arguments are provided, returns a \code{data.frame} with
columns \code{name} and \code{type}, as per \code{\link[=select.data_request]{select.data_request()}}.
}
\description{
Most data operations are done on groups defined by variables. \code{group_by()}
takes a field name (unquoted) and performs a grouping operation. The default
behaviour is to use it in combination with
\code{\link[=count.data_request]{count()}} to give information on number
of occurrences per level of that field. Alternatively, you can use it
without count to get a download of occurrences grouped by that variable. This
is particularly useful when used with a taxonomic \code{ID} field (\code{speciesID},
\code{genusID} etc.) as it allows further information to be appended to the result.
This is how \code{\link[=atlas_species]{atlas_species()}} works, for example. See
\code{\link[=select.data_request]{select()}} for details.
}
\examples{
\dontrun{
# default usage is for grouping counts
galah_call() |> 
  group_by(basisOfRecord) |>
  counts() |>
  collect()

# Alternatively, we can use this with an occurrence search  
galah_call() |>
  filter(year == 2024,
         genus = "Crinia") |>
  group_by(speciesID) |>
 collect()
# note that this example is equivalent to `atlas_species()`; 
# but using `group_by()` is more flexible.
}
}
