% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlas_taxonomy.R
\name{atlas_taxonomy}
\alias{atlas_taxonomy}
\title{Search taxonomic trees}
\usage{
atlas_taxonomy(request = NULL, identify = NULL, down_to = NULL)
}
\arguments{
\item{request}{optional \code{data_request} object: generated by a call to
\code{\link[=galah_call]{galah_call()}}.}

\item{identify}{\code{data.frame}: generated by a call to
\code{\link[=galah_identify]{galah_identify()}}.}

\item{down_to}{The identity of the clade at which the downwards search
should stop. Should be specified using an object of class
\code{character} and \code{galah_down_to}, as returned from
\code{\link[=galah_down_to]{galah_down_to()}}. Also accepts a string.}
}
\value{
A tree consisting of objects of class \code{Node}, containing the
requested taxonomy. Each node contains the following attributes:
\itemize{
\item \code{name}: The scientific name of the taxon in question
\item \code{rank}: The taxonomic rank to which that taxon belongs
\item \code{guid}: A unique identifier used by the ALA
\item \code{authority}: The source of the taxonomic name & identifier
}
}
\description{
The ALA has its' own internal taxonomy that is derived from authoritative
sources. \code{atlas_taxonomy} provides a means to query
that taxonomy, returning a tree (class \code{Node}) showing which lower
clades are contained within the specified taxon.
}
\details{
The approach used by this function is recursive, meaning that it
becomes slow for large queries such as
\code{atlas_taxonomy(search_taxa("Plantae"), down_to = galah_down_to(species))}.
Although the inputs to \code{search_taxa} and \code{down_to} are
case-insensitive, node names are always returned in title case.
}
\examples{
\donttest{
# Get a taxonomic tree of *Chordata* down to the class level
galah_call() |> 
  galah_identify("chordata") |>
  galah_down_to(class) |>
  atlas_taxonomy()
}

}
\seealso{
\code{\link[=search_taxa]{search_taxa()}} to search for an individual taxon;
\code{show_all(ranks)} for valid ranks used to specify the \code{down_to}
argument.
}
