% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ala_counts.R
\name{ala_counts}
\alias{ala_counts}
\title{Count of ALA records}
\usage{
ala_counts(
  taxa = NULL,
  filters = NULL,
  locations = NULL,
  group_by,
  limit = 100,
  type = "record"
)
}
\arguments{
\item{taxa}{\code{data.frame}: generated by a call to \code{\link{select_taxa}()}. This
argument also accepts a vector of unique species identifiers.}

\item{filters}{\code{data.frame}: generated by a call to \code{\link{select_filters}()}}

\item{locations}{\code{string}: generated by a call to \code{\link{select_locations}()}}

\item{group_by}{\code{string}: field to count by}

\item{limit}{\code{numeric}: maximum number of categories to return, defaulting to 100.
If limit is NULL, all results are returned. For some categories this will
take a while.}

\item{type}{\code{string}: one of \code{c("record", "species")}. Defaults to
"record". If "species", the number of species matching the criteria will be
returned, if "record", the number of records matching the criteria will be
returned.}
}
\value{
\itemize{
 \item{A single count, if \code{group_by} is not specified or,}
 \item{A \code{data.frame} of counts by \code{group_by} field, if it is specified}
}
}
\description{
Prior to downloading data it is often valuable to have some estimate of how
many records are available, both for deciding if the query is feasible,
and for estimating how long it will take to download. Alternatively, for some kinds
of reporting, the count of observations may be all that is required, for example
for understanding how observations are growing or shrinking in particular
locations of for particular taxa. To this end, \code{ala_counts()} takes
arguments in the same format as \code{\link{ala_occurrences}()}, and
provides either a total count of records matching the criteria, or a
\code{data.frame} of counts matching the criteria supplied to the \code{group_by}
argument.
}
\examples{
\dontrun{
# With no arguments, return the total number of records in the ALA
ala_counts()

# Group counts by state and territory
ala_counts(group_by = "stateProvince")

# Count records matching a filter
ala_counts(filters = select_filters(basisOfRecord = "FossilSpecimen"))

# Count the number of species recorded for each kingdom
ala_counts(group_by = "kingdom", type = "species")
}
}
