% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnotebook.R, R/gstackwidget.R
\name{gnotebook}
\alias{.gnotebook}
\alias{[.GNotebook}
\alias{add.GNotebook}
\alias{addHandlerChanged.GNotebook}
\alias{dispose.GNotebook}
\alias{dispose.GStackWidget}
\alias{gnotebook}
\alias{names.GNotebook}
\alias{svalue<-.GNotebook}
\title{Constructor for a tabbed notebook container}
\usage{
gnotebook(tab.pos = 3, container = NULL, ..., toolkit = guiToolkit())

.gnotebook(toolkit, tab.pos = 3, container = NULL, ...)

\method{add}{GNotebook}(obj, child, expand, fill, anchor, ...)

\method{dispose}{GNotebook}(obj, ...)

\method{names}{GNotebook}(x)

\method{svalue}{GNotebook} (obj, index=TRUE, ...) <- value

\method{[}{GNotebook}(x, i, j, ..., drop = TRUE)

\method{addHandlerChanged}{GNotebook}(obj, handler, action = NULL, ...)

\method{dispose}{GStackWidget}(obj, ...)
}
\arguments{
\item{tab.pos}{integer. Position of tabs, 1 on bottom, 2 left, 3
top, 4 right. (If supported)}

\item{container}{parent container}

\item{...}{passed to \code{add} method for container}

\item{toolkit}{underlying toolkit}

\item{obj}{gnotebook object}

\item{child}{some child component to add}

\item{expand}{NULL or logical. For box containers controls whether a child will expand to fill the allocated space.}

\item{fill}{NULL or character. For box containers. The value of \code{fill} (not
always respected) is used to control if expansion happens
vertically (\code{y}), horizontally (\code{x}) or both
(\code{both} or \code{TRUE}). For vertically filled box
containers, children always fill horizontally (atleast) and for
horizontally filled box containers, children always fill
vertically (atleast). This is important to realize when trying to
size buttons, say.}

\item{anchor}{NULL or integer. For box containers. The anchor argument is used to
position the child within the parent when there is more space
allocated than the child requests. This is specified with a
Cartesian pair in {-1,0,1} x {-1, 0, 1}.}

\item{x}{notebook object
svalue method

Set the currently raised tab by index (the default) or name}

\item{index}{\code{TRUE} refer to tab by 1-based
index; \code{FALSE} allows reference by tab label.}

\item{value}{assignment value}

\item{i}{row index. Either integer or character}

\item{j}{ignored}

\item{drop}{ignored}

\item{handler}{handler}

\item{action}{passed along to handler via \code{h[["action"]]}.}
}
\value{
none. called for its side effect.
}
\description{
The tabbed notebook container allows one to hold many different
pages with a mechanism -- tabs -- to switch between them. In
\code{gWidgets2} new pages are added through the \code{add}
method. This is usually called implicitly in the child object's
constructor. One passes in the tab label through the extra
\code{label} argument. Labels may be subsequently changed through
\code{names<-}.

generic for toolkit dispatch

Children added to notebooks need a label, a position and
optionally a close button (if supported). The arguments expand,
fill, anchor are not specified -- children expand and fill the allocated space.

Dispose deletes the current page, not the entire notebook
object. To delete a specific page, a combination of
\code{svalue<-} and \code{dispose} may be used.

The \code{names} of a notebook are the page tab labels. These may
be retrieved and set through the \code{names} method.

The notebook object contains pages referenced by index. This allows access to underlying page.

The change handler for the notebook is called when the page
changes. Tthe new page number is passed back in the \code{page.no}
component of 'h', which in some cases may differ from the value
given by \code{svalue} within the handler call.

Dispose deletes the current page, not the entire notebook
object. To delete a specific page, a combination of
\code{svalue<-} and \code{dispose} may be used.
}
\note{
In \pkg{gWidgets2} the button arguments of the
\code{gWidgets} constructor are removed. One passes the close
button request to the \code{add} method.

To keep the signature the same as the generic, several arguments are passed in via ...:

\describe{

\item{label}{ A character. Label text for tab}

\item{i}{An integer in \code{0} to \code{length(obj)} indicating
the position to insert child. The new page is inserted to the
right of page  number \code{i}. When \code{i=0}, the page appears
at the front, when \code{i} is not specified it appears at the
end.
}

\item{close.button}{A logical. If \code{TRUE} -- and the toolkit
supports it -- the page tab will include a close button.
}
}
}
\examples{
\dontrun{

w <- gwindow("notebook example", visible=FALSE)
nb <- gnotebook(container=w)
gbutton("Page one", label="tab 1", container=nb) ## note label argument
gbutton("Page two", label="tab 2", container=nb)
svalue(nb) <- 1
addHandlerChanged(nb, handler=function(h,...) {
  message(sprintf("On page \%s", h$page.no)) ## svalue(h$obj) not always right
})
svalue(nb) <- 2 ## or use "Page two"
dispose(nb)
length(nb)

}
}
\seealso{
\code{\link{gstackwidget}} for a similar widget without
tabs.
}

