% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGstats.R
\name{CGstats}
\alias{CGstats}
\alias{CGstats.data.frame}
\alias{CGstats_internal}
\alias{print.CGstats}
\title{Mean, covariance and counts for grouped data}
\usage{
CGstats(object, varnames = NULL, homogeneous = TRUE, simplify = TRUE)
}
\arguments{
\item{object}{A dataframe.}

\item{varnames}{Names of variables to be used.}

\item{homogeneous}{Logical; if TRUE a common covariance matrix is reported.}

\item{simplify}{Logical; if TRUE the result will be presented in a simpler
form.}
}
\value{
A list whose form depends on the type of input data and the varnames.
}
\description{
\code{CGstats} provides what corresponds to calling
    \code{cow.wt} on different strata of data where the strata are defined by
    the combinations of factors in data.
}
\examples{

data(milkcomp)
# milkcomp <- subset(milkcomp, (treat \%in\% c("a","b")) & (lactime \%in\% c("t1", "t2")))
# milkcomp <- milkcomp[,-1]
# milkcomp$treat 		<- factor(milkcomp$treat)
# milkcomp$lactime 	<- factor(milkcomp$lactime)

CGstats(milkcomp)
CGstats(milkcomp, c(1,2))
CGstats(milkcomp, c("lactime","treat"))
CGstats(milkcomp, c(3,4))
CGstats(milkcomp, c("fat","protein"))

CGstats(milkcomp, c(2,3,4), simplify=FALSE)
CGstats(milkcomp, c(2,3,4), homogeneous=FALSE)
CGstats(milkcomp, c(2,3,4), simplify=FALSE, homogeneous=FALSE)



}
\seealso{
\code{\link{cov.wt}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
