% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadSaveHuginNet.R
\name{load-save-hugin}
\alias{load-save-hugin}
\alias{loadHuginNet}
\alias{saveHuginNet}
\title{Load and save Hugin net files}
\usage{
loadHuginNet(file, description = NULL, details = 0)

saveHuginNet(gin, file, details = 0)
}
\arguments{
\item{file}{Name of Hugin net file. Convenient to give the file the
extension '.net'}

\item{description}{A text describing the network, defaults to
\code{file}}

\item{details}{Debugging information.}

\item{gin}{An independence network}
}
\value{
An object of class \code{grain}.
}
\description{
These functions can load a net file saved in the
'Hugin format' into R and save a network in R as a file in the
'Hugin format'.
}
\note{
\itemize{
\item In Hugin, it is possible to specify the potential of a node as a
functional relation between other nodes.  In a .net file, such a
specification will appear as 'function' rather than as
'node'. Such a specification is not recognized by \code{loadHuginNet}.
\item It is recommended to avoid the text \code{node} as part of the name of
a node.
}
}
\examples{


## Load HUGIN net file
tf <- system.file("huginex", "chest_clinic.net", package = "gRain")
chest <- loadHuginNet(tf, details=1)
chest 

## Save a copy
td <- tempdir()
saveHuginNet(chest, paste(td,"/chest.net",sep=''))

## Load the copy
chest2 <- loadHuginNet(paste(td,"/chest.net",sep=''))

tf <- system.file("huginex", "golf.net", package = "gRain")
golf <- loadHuginNet(tf, details=1)

saveHuginNet(golf, paste(td,"/golf.net",sep=''))
golf2 <- loadHuginNet(paste(td,"/golf.net",sep=''))

}
\references{
Søren Højsgaard (2012). Graphical Independence
Networks with the gRain Package for R. Journal of Statistical
Software, 46(10), 1-26.
\url{https://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{grain}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
