% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndset.R
\name{criterionPoints}
\alias{criterionPoints}
\title{Calculate the criterion points of a set of points and ranges to find the set
of non-dominated points (Pareto points) and classify them into extreme
supported, non-extreme supported, non-supported.}
\usage{
criterionPoints(pts, obj, crit, labels = "coord")
}
\arguments{
\item{pts}{A data frame with a column for each variable in the solution
space (can also be a rangePoints).}

\item{obj}{A p x n matrix(one row for each criterion).}

\item{crit}{Either max or min.}

\item{labels}{If \code{NULL} or "n" don't add any labels (empty string). If
'coord' labels are the solution space coordinates. Otherwise number all
points from one based on the solution space points.}
}
\value{
A data frame with columns x1, ..., xn, z1, ..., zp, lbl (label), nD
(non-dominated), ext (extreme), nonExt (non-extreme supported).
}
\description{
Calculate the criterion points of a set of points and ranges to find the set
of non-dominated points (Pareto points) and classify them into extreme
supported, non-extreme supported, non-supported.
}
\examples{
A <- matrix( c(3, -2, 1, 2, 4, -2, -3, 2, 1), nc = 3, byrow = TRUE)
b <- c(10,12,3)
pts <- integerPoints(A, b)
obj <- matrix( c(1,-3,1,-1,1,-1), byrow = TRUE, ncol = 3 )
criterionPoints(pts, obj, crit = "max", labels = "numb")
}
\author{
Lars Relund \email{lars@relund.dk}
}
