% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gMCP.extended.R
\name{bonferroni.test}
\alias{bonferroni.test}
\title{Weighted Bonferroni-test}
\usage{
bonferroni.test(pvalues, weights, alpha = 0.05, adjPValues = TRUE,
  verbose = FALSE, ...)
}
\arguments{
\item{pvalues}{A numeric vector specifying the p-values.}

\item{weights}{A numeric vector of weights.}

\item{alpha}{A numeric specifying the maximal allowed type one error rate. If \code{adjPValues==TRUE} (default) the parameter \code{alpha} is not used.}

\item{adjPValues}{Logical scalar. If \code{TRUE} (the default) an adjusted p-value for the weighted Bonferroni-test is returned.
Otherwise if \code{adjPValues==FALSE} a logical value is returned whether the null hypothesis can be rejected.}

\item{verbose}{Logical scalar. If \code{TRUE} verbose output is generated.}

\item{...}{Further arguments possibly passed by \code{gMCP} which will be used by other test procedures but not this one.}
}
\description{
Weighted Bonferroni-test
}
\examples{
bonferroni.test(pvalues=c(0.1,0.2,0.05), weights=c(0.5,0.5,0))
bonferroni.test(pvalues=c(0.1,0.2,0.05), weights=c(0.5,0.5,0), adjPValues=FALSE)
}

