/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.power;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.af.commons.widgets.validate.ValidationException;
import org.af.gMCP.gui.graph.LaTeXTool;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.power.Arm;
import org.af.gMCP.gui.power.EndpointDialog;
import org.af.gMCP.gui.power.PopulationDialog;
import org.af.gMCP.gui.power.SampleSizeDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RandomizationPanel
extends JPanel
implements ActionListener {
    List<Arm> armL = new Vector<Arm>();
    JButton addArm = new JButton("Add arm");
    JButton rmArm = new JButton("Remove last arm");
    JButton jbEndpoint = new JButton("Endpoint");
    JButton jbPopulation = new JButton("Population");
    SampleSizeDialog sd;
    JPanel panel = new JPanel();

    public RandomizationPanel(SampleSizeDialog sd) {
        this.sd = sd;
        this.armL.add(new Arm(sd, "Arm " + (this.armL.size() + 1)));
        this.setUpLayout();
    }

    public void setUpLayout() {
        CellConstraints cc = new CellConstraints();
        int row = 2;
        String cols = "5dlu, fill:min:grow, pref, 5dlu, pref, 5dlu";
        String rows = "5dlu, fill:min:grow, 5dlu, pref, 5dlu, pref, 5dlu";
        this.setLayout((LayoutManager)new FormLayout(cols, rows));
        this.add((Component)new JScrollPane(this.getMainPanel()), cc.xyw(2, row, 4));
        this.add((Component)this.addArm, cc.xy(3, row += 2));
        this.add((Component)this.rmArm, cc.xy(5, row));
        this.addArm.addActionListener(this);
        this.rmArm.addActionListener(this);
        this.rmArm.setEnabled(false);
        this.add((Component)this.jbEndpoint, cc.xy(3, row += 2));
        this.add((Component)this.jbPopulation, cc.xy(5, row));
        this.jbEndpoint.addActionListener(this);
        this.jbPopulation.addActionListener(this);
    }

    public JPanel getMainPanel() {
        this.panel.removeAll();
        CellConstraints cc = new CellConstraints();
        int row = 2;
        String cols = "5dlu, pref, 5dlu, pref, 5dlu";
        String rows = "5dlu, pref, 5dlu";
        for (Node n : this.sd.getNodes()) {
            cols = cols + ", pref, 5dlu";
        }
        for (Arm g : this.armL) {
            rows = rows + ", pref, 5dlu";
        }
        this.panel.setLayout((LayoutManager)new FormLayout(cols, rows));
        int col = 2;
        this.panel.add((Component)new JLabel("Arm"), cc.xy(col, row));
        this.panel.add((Component)new JLabel("Ratio to first Arm "), cc.xy(col += 2, row));
        for (Node n : this.sd.nodes) {
            this.panel.add((Component)new JLabel(LaTeXTool.LaTeX2UTF(n.getName())), cc.xy(col += 2, row));
        }
        for (Arm g : this.armL) {
            g.addComponents(this.panel, cc, row += 2);
        }
        return this.panel;
    }

    public String getESF() throws ValidationException {
        Vector nodes = this.sd.nodes;
        double sum = 0.0;
        for (Arm g : this.armL) {
            sum += g.getRatio().doubleValue();
        }
        Vector<Double> r = new Vector<Double>();
        for (int j = 0; j < this.armL.size(); ++j) {
            r.add(this.armL.get(j).getRatio() / sum);
        }
        String esf = "c(";
        for (int i = 0; i < nodes.size(); ++i) {
            Vector<Integer> armsInvolved = new Vector<Integer>();
            for (int j = 0; j < this.armL.size(); ++j) {
                if (!this.armL.get(j).isSelected(i)) continue;
                armsInvolved.add(j);
            }
            if (armsInvolved.size() == 0) {
                throw new ValidationException("No arm involved in hypothesis " + ((Node)nodes.get(i)).getName() + ".");
            }
            if (armsInvolved.size() == 1) {
                Double ri = (Double)r.get((Integer)armsInvolved.get(0));
                esf = esf + Math.sqrt(ri) + ", ";
                continue;
            }
            if (armsInvolved.size() == 2) {
                Double ri = (Double)r.get((Integer)armsInvolved.get(0));
                Double rj = (Double)r.get((Integer)armsInvolved.get(1));
                esf = esf + Math.sqrt(ri * rj / (ri + rj)) + ", ";
                continue;
            }
            if (armsInvolved.size() <= 2) continue;
            throw new ValidationException("Too many arms involvedin hypothesis " + ((Node)nodes.get(i)).getName() + ".");
        }
        return esf.substring(0, esf.length() - 2) + ")";
    }

    public String getRatio() throws ValidationException {
        String ratio = "c(";
        for (Arm g : this.armL) {
            ratio = ratio + g.getRatio() + ", ";
        }
        return ratio.substring(0, ratio.length() - 2) + ")";
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addArm) {
            this.armL.add(new Arm(this.sd, "Arm " + (this.armL.size() + 1)));
            this.getMainPanel();
            this.revalidate();
            this.repaint();
            this.rmArm.setEnabled(true);
        } else if (e.getSource() == this.rmArm) {
            if (this.armL.size() > 1) {
                this.armL.remove(this.armL.size() - 1);
                this.getMainPanel();
                this.revalidate();
                this.repaint();
            }
            if (this.armL.size() == 1) {
                this.rmArm.setEnabled(false);
            }
        } else if (e.getSource() == this.jbEndpoint) {
            new EndpointDialog(this.sd);
        } else if (e.getSource() == this.jbPopulation) {
            new PopulationDialog(this.sd);
        }
    }

    public Element getConfigNode(Document document) {
        Element e = document.createElement("randomization");
        e.setAttribute("numberArms", "" + this.armL.size());
        e.setAttribute("numberHS", "" + this.armL.get((int)0).includeL.size());
        for (Arm a : this.armL) {
            e.appendChild(a.getConfigNode(document));
        }
        return e;
    }

    public void loadConfig(Element e) {
        int nArms = Integer.parseInt(e.getAttribute("numberArms"));
        int nHS = Integer.parseInt(e.getAttribute("numberHS"));
        while (this.armL.size() < nArms) {
            this.armL.add(new Arm(this.sd, "Arm " + (this.armL.size() + 1)));
            this.rmArm.setEnabled(true);
        }
        NodeList nlist = e.getChildNodes();
        for (int i = 0; i < this.armL.size(); ++i) {
            this.armL.get(i).loadConfig((Element)nlist.item(i));
        }
        this.getMainPanel();
        this.revalidate();
        this.repaint();
    }
}

