/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Vector;
import org.af.commons.tools.StringTools;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.graph.LaTeXTool;
import org.af.gMCP.gui.graph.NetList;
import org.af.gMCP.gui.graph.NodeListener;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    static DecimalFormat format = new DecimalFormat("#.####");
    static DecimalFormat formatSmall = new DecimalFormat("#.###E0");
    public static int r = 25;
    private Color color = Color.WHITE;
    TeXIcon iconName;
    List<TeXIcon> iconWeight;
    int lastFontSize = 14;
    public Vector<NodeListener> listener = new Vector();
    Double localPower = null;
    private String name;
    NetList nl;
    private boolean rejectable = false;
    boolean rejected = false;
    private List<String> stringW = new Vector<String>();
    private List<Double> weight = new Vector<Double>();
    int x;
    int y;

    public Node(String name, int x, int y, double[] alpha, NetList vs) {
        this.nl = vs;
        this.setName(name);
        this.setX(x);
        this.setY(y);
        this.setWeight(alpha, null);
    }

    public void addNodeListener(NodeListener l) {
        this.listener.add(l);
    }

    public Color getColor() {
        if (this.rejected) {
            return Color.MAGENTA;
        }
        return this.color;
    }

    public String getName() {
        return this.name;
    }

    public String getRName() {
        return this.name.replaceAll("\\\\", "\\\\\\\\");
    }

    public List<Double> getWeight() {
        return this.weight;
    }

    private List<String> getWS() {
        return this.stringW;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean inYou(int x, int y) {
        return ((double)x / this.nl.getZoom() - (double)this.x - (double)r) * ((double)x / this.nl.getZoom() - (double)this.x - (double)r) + ((double)y / this.nl.getZoom() - (double)this.y - (double)r) * ((double)y / this.nl.getZoom() - (double)this.y - (double)r) <= (double)(r * r);
    }

    public boolean containsYou(int[] start, int[] end) {
        return (double)Math.min(start[0], end[0]) / this.nl.getZoom() <= (double)(this.x + r) && (double)Math.max(start[0], end[0]) / this.nl.getZoom() >= (double)(this.x - r) && (double)Math.min(start[1], end[1]) / this.nl.getZoom() <= (double)(this.y + r) && (double)Math.max(start[1], end[1]) / this.nl.getZoom() >= (double)(this.y - r);
    }

    public static int getRadius() {
        return r;
    }

    public static void setRadius(int radius) {
        r = radius;
    }

    public boolean isRejectable() {
        return this.rejectable && !this.rejected;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public int[] offset(int x2, int y2) {
        return new int[]{(int)((double)this.x * this.nl.getZoom()) - x2, (int)((double)this.y * this.nl.getZoom()) - y2};
    }

    public void paintYou(Graphics g) {
        Rectangle2D rc;
        if (this.rejected && !Configuration.getInstance().getGeneralConfig().showRejected()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setFont(new Font("Arial", 0, (int)(12.0 * this.nl.getZoom())));
        FontRenderContext frc = g2d.getFontRenderContext();
        g2d.setColor(this.getColor());
        Ellipse2D.Double e = new Ellipse2D.Double();
        ((RectangularShape)e).setFrame((double)this.x * this.nl.getZoom(), (double)this.y * this.nl.getZoom(), (double)(r * 2) * this.nl.getZoom(), (double)(r * 2) * this.nl.getZoom());
        g2d.fill(e);
        g2d.setColor(new Color(0, 0, 0));
        ((RectangularShape)e).setFrame((double)this.x * this.nl.getZoom(), (double)this.y * this.nl.getZoom(), (double)(r * 2) * this.nl.getZoom(), (double)(r * 2) * this.nl.getZoom());
        g2d.draw(e);
        if (this.localPower != null) {
            String s = format.format(this.localPower);
            rc = g2d.getFont().getStringBounds(s, frc);
            g2d.drawString(s, (float)((double)(this.x + r) * this.nl.getZoom() - rc.getWidth() / 2.0), (float)(((double)this.y + 2.5 * (double)r) * this.nl.getZoom()));
        }
        if (!Configuration.getInstance().getGeneralConfig().useJLaTeXMath()) {
            rc = g2d.getFont().getStringBounds(this.name, frc);
            g2d.drawString(this.name, (float)((double)(this.x + r) * this.nl.getZoom() - rc.getWidth() / 2.0), (float)(((double)(this.y + r) - 0.25 * (double)r) * this.nl.getZoom()));
            rc = g2d.getFont().getStringBounds(StringTools.collapseStringList(this.getWS(), (String)" "), frc);
            g2d.drawString(StringTools.collapseStringList(this.getWS(), (String)" "), (float)((double)(this.x + r) * this.nl.getZoom() - rc.getWidth() / 2.0), (float)(((double)this.y + 1.5 * (double)r) * this.nl.getZoom()));
        } else {
            if (this.lastFontSize != (int)(14.0 * this.nl.getZoom())) {
                this.lastFontSize = (int)(14.0 * this.nl.getZoom());
                this.createWeightIcons();
                TeXFormula formula = new TeXFormula("\\mathbf{" + this.name + "}");
                this.iconName = formula.createTeXIcon(2, (float)this.lastFontSize);
            }
            this.iconName.paintIcon(LaTeXTool.panel, (Graphics)g2d, (int)((double)(this.x + r) * this.nl.getZoom() - (double)(this.iconName.getIconWidth() / 2)), (int)(((double)(this.y + r) - 0.6 * (double)r) * this.nl.getZoom()));
            int offset = (int)(-((double)(this.iconWeight.size() - 1) / 2.0) * 10.0);
            for (TeXIcon icon : this.iconWeight) {
                icon.paintIcon(LaTeXTool.panel, (Graphics)g2d, (int)((double)(this.x + r + offset) * this.nl.getZoom() - (double)(icon.getIconWidth() / 2)), (int)(((double)this.y + 1.1 * (double)r) * this.nl.getZoom()));
                offset += 10;
            }
        }
    }

    public void createWeightIcons() {
        this.lastFontSize = (int)(14.0 * this.nl.getZoom());
        int fontSize = (int)(14.0 * this.nl.getZoom() * (this.getWS().size() == 1 ? 1.0 : 0.8));
        this.iconWeight = new Vector<TeXIcon>();
        int layer = 0;
        for (String w : this.getWS()) {
            TeXIcon icon = LaTeXTool.getTeXIcon(this.nl.control.getGraphGUI(), w, fontSize);
            icon.setForeground(NetList.layerColors[layer % NetList.layerColors.length]);
            this.iconWeight.add(icon);
            ++layer;
        }
    }

    public void reject() {
        this.nl.acceptNode(this);
        for (NodeListener l : this.listener) {
            l.reject();
        }
    }

    public void setColor(Color color) {
        this.color = color;
        this.nl.repaint();
    }

    public void setLocalPower(double d) {
        this.localPower = d;
    }

    public void setName(String name) {
        this.name = name;
        TeXFormula formula = new TeXFormula("\\mathbf{" + name + "}");
        this.iconName = formula.createTeXIcon(2, (float)((int)(14.0 * this.nl.getZoom())));
        this.nl.graphHasChanged();
    }

    public void setRejectable(boolean rejectable) {
        if (rejectable) {
            this.setColor(new Color(50, 255, 50));
        } else {
            this.setColor(Color.WHITE);
        }
        this.rejectable = rejectable;
    }

    public void setWeight(double[] alpha, NodeListener me) {
        DecimalFormat format = Configuration.getInstance().getGeneralConfig().getDecFormat();
        this.weight = new Vector<Double>();
        this.stringW = new Vector<String>();
        for (double w : alpha) {
            this.addSingleLayerWeight(w);
        }
        this.createWeightIcons();
        for (NodeListener l : this.listener) {
            if (me == l) continue;
            l.updated(this);
        }
        this.nl.graphHasChanged();
        this.nl.repaint();
    }

    public void addSingleLayerWeight(double w) {
        this.weight.add(w);
        if (!Configuration.getInstance().getGeneralConfig().showFractions()) {
            this.stringW.add(format.format(w));
        } else if (w != 0.0 && w < Math.pow(0.1, 3.0)) {
            this.stringW.add(formatSmall.format(w));
        } else {
            String wS = RControl.getFraction((Double)w, 5);
            if (wS.length() > 7) {
                wS = "\\sim " + format.format(w);
            }
            this.stringW.add(wS);
        }
    }

    public void addLayer() {
        this.addSingleLayerWeight(0.0);
        this.lastFontSize = 0;
    }

    public void setX(int x) {
        int grid = Configuration.getInstance().getGeneralConfig().getGridSize();
        this.x = x = (x + (int)(0.5 * (double)grid)) / grid * grid;
    }

    public void setY(int y) {
        int grid = Configuration.getInstance().getGeneralConfig().getGridSize();
        this.y = y = (y + (int)(0.5 * (double)grid)) / grid * grid;
    }

    public String toString() {
        return this.name + " (w: " + this.getWS() + ")";
    }

    public void removeLayer(int layer) {
        this.weight.remove(layer);
        this.stringW.remove(layer);
        this.lastFontSize = 0;
    }
}

