/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph.annotations;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParser;
import org.af.gMCP.gui.graph.annotations.AnnotationPanel;
import org.af.gMCP.gui.graph.annotations.Legend;
import org.af.gMCP.gui.graph.annotations.TestPanel;

public abstract class Annotation {
    int x;
    int y;
    Color color = Color.BLACK;
    protected AnnotationPanel nl;
    static final String CLASS = "Class";

    public String saveToJSON() {
        StringWriter sw = new StringWriter();
        JsonGenerator gen = Json.createGenerator((Writer)sw);
        gen.writeStartObject().write(CLASS, this.getClass().getCanonicalName());
        this.writeObject(gen);
        gen.writeEnd();
        gen.close();
        return sw.toString();
    }

    public int[] offset(int x2, int y2) {
        return new int[]{(int)((double)this.x * this.nl.getZoom()) - x2, (int)((double)this.y * this.nl.getZoom()) - y2};
    }

    public abstract Annotation readJSON(String var1);

    public abstract void writeObject(JsonGenerator var1);

    public abstract Dimension paintObject(Graphics var1);

    public abstract String getLaTeX();

    public abstract boolean inYou(int var1, int var2);

    public static Annotation createAnnotation(String s) {
        JsonParser parser = Json.createParser((Reader)new StringReader(s));
        String key = "";
        Annotation a = null;
        try {
            while (parser.hasNext()) {
                JsonParser.Event event = parser.next();
                switch (event) {
                    case START_ARRAY: 
                    case END_ARRAY: 
                    case START_OBJECT: 
                    case END_OBJECT: 
                    case VALUE_FALSE: 
                    case VALUE_NULL: 
                    case VALUE_TRUE: {
                        break;
                    }
                    case KEY_NAME: {
                        key = parser.getString();
                        break;
                    }
                    case VALUE_STRING: 
                    case VALUE_NUMBER: {
                        String v = parser.getString();
                        if (!key.equals(CLASS)) break;
                        System.out.println("Creating object of class " + v);
                        a = (Annotation)Class.forName(v).getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return a;
    }

    public static void main(String[] args) {
        Legend l = new Legend(100, 100, Arrays.asList("Component Weights", "Component Graph 1: 0.5", "Component Graph 1: 0.3", "Component Graph 1: 0.2"), Arrays.asList(Color.BLACK, Color.RED, Color.GREEN, Color.BLUE), new TestPanel());
        String s = l.saveToJSON();
        System.out.println(s);
        Annotation.createAnnotation(s);
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

