/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.af.commons.io.pdf.PDFHelper;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.graph.GraphView;
import org.af.gMCP.gui.pdf.Plot;
import org.af.gMCP.gui.pdf.Result;
import org.af.gMCP.gui.pdf.Step;
import org.af.jhlir.call.RDataFrame;
import org.af.jhlir.call.RObj;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFGenerator {
    private static final Log logger = LogFactory.getLog(PDFGenerator.class);
    private List<Step> selectedSteps;
    public static Font font = new Font(2, 10.0f, 0);
    public static Font fontb = new Font(2, 10.0f, 1);
    public static Font fonth = new Font(2, 12.0f, 1);
    GraphView control;
    DateFormat df = DateFormat.getDateInstance(1, Locale.ENGLISH);

    public PDFGenerator(GraphView control, List<Step> selectedSteps) {
        this.control = control;
        this.selectedSteps = selectedSteps;
    }

    public void makePDF() throws FileNotFoundException, DocumentException {
        Calendar calendar = Calendar.getInstance();
        String filename = "Report - " + this.df.format(calendar.getTime()) + ".pdf";
        filename = filename.replace(':', '-');
        File outputFile = new File(Configuration.getInstance().getClassProperty(this.getClass(), "pdfDirectory", System.getProperty("user.home")), filename);
        this.makePDF(outputFile);
    }

    public void makePDF(File outputFile) throws FileNotFoundException, DocumentException {
        Document document = new Document();
        logger.info((Object)("Creating pdf " + outputFile.getAbsolutePath() + "."));
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(outputFile));
        document.addTitle("Report");
        document.addSubject("Statistical Report");
        document.addKeywords("Statistical Report");
        document.addCreator("iText used by the R Java Client - http://www.algorithm-forge.com/rjavaclient/");
        document.open();
        document.close();
    }

    public void addHeaderFooter(Document document) {
    }

    public void addResult(Document document, PdfWriter writer, Result result, List<Plot> plots) throws DocumentException {
        if (result != null) {
            try {
                logger.info((Object)"Appending plots.");
                for (int i = 0; i < plots.size(); ++i) {
                    File file = plots.get(i).getPNGFile();
                    document.add((Element)this.getImage(writer, file));
                    PDFGenerator.addCaption(document, plots.get((int)i).caption);
                }
            }
            catch (IOException e) {
                logger.fatal((Object)"Error adding image to PDF.", (Throwable)e);
            }
        }
    }

    public static void addCaption(Document document, String caption) throws DocumentException {
        if (caption != null) {
            Paragraph p = new Paragraph(new Chunk(caption + "\n\n", fontb));
            p.setAlignment(1);
            document.add((Element)p);
        }
    }

    private int getNr(String s, int n) {
        int nr = 0;
        while (n < s.length() && s.charAt(n) != '$') {
            int read = Integer.parseInt("" + s.charAt(n));
            nr = nr * 10 + read;
            ++n;
        }
        return nr;
    }

    private Image getImage(PdfWriter writer, File file) throws IOException, BadElementException {
        Image image = PDFHelper.getImage((PdfWriter)writer, (File)file);
        image.scaleToFit(300.0f, 300.0f);
        image.setAlignment(1);
        writer.setStrictImageSequence(true);
        return image;
    }

    public boolean isPDF(File file) {
        String name = file.getName();
        logger.info((Object)("Is " + name + " a PDF file?"));
        boolean result = false;
        String extension = name.substring(file.getName().length() - 3);
        logger.info((Object)("Extension is: " + extension));
        if (extension.equalsIgnoreCase("pdf")) {
            result = true;
        }
        logger.info((Object)("Result: " + result));
        return result;
    }

    public PdfPTable createTable(RObj xtable) throws BadElementException, RemoteException {
        Cell cell;
        RDataFrame df = RControl.getR().call("as.data.frame", new Object[]{xtable}).asRDataFrame();
        PdfPTable table = new PdfPTable(df.getColumnCount() + 1);
        logger.info((Object)"Writing headline of pdftable.");
        Vector<String> list = new Vector<String>();
        list.add("");
        Collections.addAll(list, df.getColNames());
        for (String s : list) {
            cell = new Cell((Element)new Chunk(s, fontb));
            cell.enableBorderSide(4);
            cell.enableBorderSide(8);
            cell.enableBorderSide(2);
            cell.setBorderWidth(0.5f);
            table.addCell(cell.createPdfPCell());
        }
        logger.info((Object)("The table has " + df.getRowCount() + " rows and " + df.getColumnCount() + " columns."));
        for (int i = 0; i < df.getRowCount(); ++i) {
            logger.info((Object)("Writing row " + (i + 1) + " of " + df.getRowCount() + "."));
            cell = new Cell((Element)new Chunk(df.getRowName(i), font));
            PDFHelper.enable4Borders((Cell)cell);
            table.addCell(cell.createPdfPCell());
            for (int j = 0; j < df.getColumnCount(); ++j) {
                logger.info((Object)("Writing element (" + i + "," + (j + 1) + "):"));
                String element = this.createString(df.getCol(i).get(i), false);
                cell = new Cell((Element)new Chunk(element, font));
                logger.info((Object)element);
                PDFHelper.enable4Borders((Cell)cell);
                table.addCell(cell.createPdfPCell());
            }
        }
        return table;
    }

    public String createString(Object o, boolean appendZeros) {
        if (o instanceof Float || o instanceof Double) {
            int digits = Configuration.getInstance().getGeneralConfig().getDigits();
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb);
            formatter.format("%." + digits + "f", o);
            return sb.toString();
        }
        return o.toString();
    }
}

