/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.config;

import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.mutoss.config.Configuration;
import org.mutoss.config.SpecificConfig;

public class GeneralConfig
extends SpecificConfig {
    public static final String DISABLE = "disable";

    GeneralConfig(Configuration conf) {
        super(conf);
    }

    private String getHash() {
        return this.getProperty("hash", "___NOT_FOUND___");
    }

    public void setPassPhrase(String s) {
        this.setProperty("pass.phrase", s);
    }

    public String getPassPhrase() {
        return this.getProperty("pass.phrase", "");
    }

    public boolean isPasswordProtected() {
        return !this.getHash().equals("___NOT_FOUND___") && !this.getHash().equals("");
    }

    public static String getMD5(String s) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.reset();
        md5.update(s.getBytes());
        byte[] result = md5.digest();
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < result.length; ++i) {
            hexString.append(Integer.toHexString(0xFF & result[i]));
        }
        return hexString.toString();
    }

    public boolean isValidPassword(String s) throws NoSuchAlgorithmException {
        String h = GeneralConfig.getMD5(s);
        s = this.getHash();
        logger.info((Object)("Hashvalue: " + h));
        logger.info((Object)"Passphrases: ");
        while (s.indexOf(";") != -1) {
            String p = s.substring(0, s.indexOf(";"));
            logger.info((Object)p);
            if (p.equals(h)) {
                return true;
            }
            s = s.substring(s.indexOf(";") + 1, s.length());
        }
        logger.info((Object)s);
        return s.equals(h);
    }

    public void setCheckForUpdates(boolean check) {
        this.setProperty("check.for.updates", "" + check);
    }

    public String getCheckForUpdates() {
        return this.getProperty("check.for.updates", "true");
    }

    public void setOldSVNVersion(String s) {
        this.setProperty("old.svn.version", s);
    }

    public String getOldSVNVersion() {
        return this.getProperty("old.svn.version", "0");
    }

    public String getSVNVersion() {
        return this.getProperty("svn.version");
    }

    public void setTempDir(String tempDir) {
        this.setProperty("tempdir", tempDir);
    }

    public String getTempDir() {
        String tmpDir = this.getProperty("tempdir", "");
        if (tmpDir.trim().equals("")) {
            tmpDir = System.getProperty("java.io.tmpdir");
        }
        return tmpDir;
    }

    public File getProjectPDFsPath() {
        return new File(this.getProperty("pdf.output", System.getProperty("user.dir")));
    }

    public void setProjectPDFsPath(String path) {
        this.setProperty("pdf.output", path);
    }

    public void setPDFViewerPath(String pdfViewerPath) {
        this.setProperty("acrobat.path", pdfViewerPath);
    }

    public String getPDFViewerPath() {
        return this.getProperty("acrobat.path", "");
    }

    public String getDesktopPath() {
        return this.getProperty("desktop.path", "");
    }

    public void setDesktopPath(String desktopPath) {
        this.setProperty("desktop.path", desktopPath);
    }

    public void setPDFViewerOptions(String pdfViewerOptions) {
        this.setProperty("pdfviewer.options", pdfViewerOptions);
    }

    public String getPDFViewerOptions() {
        return this.getProperty("pdfviewer.options", "");
    }

    public void setFontSize(int i) {
        this.setIntProperty("font.size", i);
    }

    public int getFontSize() {
        return this.getIntProperty("font.size", "12");
    }

    public String getSetupTitle() {
        return this.getProperty("setup.title");
    }

    public String getApplicationTitle() {
        return this.getProperty("application.title");
    }

    public String getAboutTitle() {
        return this.getProperty("about.title");
    }

    public String getCopyright() {
        return this.getProperty("about.copyright");
    }

    public void setClassProperty(Class c, String key, String value) {
        String cn = c.getName().substring(c.getName().lastIndexOf(46));
        this.setProperty(cn + "." + key, value);
    }

    public String getClassProperty(Class c, String key) {
        String cn = c.getName().substring(c.getName().lastIndexOf(46));
        return this.getProperty(cn + "." + key, "___NOT_FOUND___");
    }

    public void setLanguage(String string) {
        this.setProperty("language", string);
    }

    public String getLanguage() {
        return this.getProperty("language", null);
    }

    public void setGridSize(int grid) {
        this.setProperty("grid", "" + grid);
    }

    public int getGridSize() {
        return Integer.parseInt(this.getProperty("grid", "10"));
    }

    public boolean getColoredImages() {
        return Boolean.parseBoolean(this.getProperty("coloredImages", "true"));
    }

    public void setColoredImages(boolean colored) {
        this.setProperty("coloredImages", "" + colored);
    }

    public int getDigitsInTables() {
        return Integer.parseInt(this.getProperty("digits.in.tables", "6"));
    }

    public boolean showRejected() {
        return Boolean.parseBoolean(this.getProperty("showRejected", "true"));
    }

    public void setShowRejected(boolean showRejected) {
        this.setProperty("showRejected", "" + showRejected);
    }
}

