/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.jdesktop.jxlayer.plaf.item.LayerItemChangeEvent;
import org.jdesktop.jxlayer.plaf.item.LayerItemChangeSupport;
import org.jdesktop.jxlayer.plaf.item.LayerItemListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractLayerUI<V extends JComponent>
extends LayerUI<V> {
    private static final LayerEventController eventController = new LayerEventController();
    private long eventMask = super.getLayerEventMask();
    private final LayerItemChangeSupport layerChangeSupport = new LayerItemChangeSupport(this);
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private static final Map<RenderingHints.Key, Object> emptyRenderingHintMap = Collections.unmodifiableMap(new HashMap(0));
    private boolean enabled = true;
    private boolean isDirty;

    @Override
    public void installUI(JComponent jComponent) {
        JXLayer jXLayer = (JXLayer)jComponent;
        this.addLayerItemListener(jXLayer);
        this.addPropertyChangeListener(jXLayer);
        if (this.isAWTEventListenerEnabled()) {
            jXLayer.setProxyInputContextEnabled(false);
            this.registerAWTEventListener(jXLayer, this.getLayerEventMask());
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        JXLayer jXLayer = (JXLayer)jComponent;
        this.removeLayerItemListener(jXLayer);
        this.removePropertyChangeListener(jXLayer);
        if (this.isAWTEventListenerEnabled()) {
            this.unregisterAWTEventListener(jXLayer);
            jXLayer.setProxyInputContextEnabled(true);
        }
    }

    protected void registerAWTEventListener(JXLayer<V> jXLayer, long l) {
        eventController.register(jXLayer, l);
    }

    protected void unregisterAWTEventListener(JXLayer<V> jXLayer) {
        eventController.unregister(jXLayer);
    }

    protected boolean isAWTEventListenerEnabled() {
        return false;
    }

    @Override
    public long getLayerEventMask() {
        return this.eventMask;
    }

    public void setLayerEventMask(long l) {
        long l2 = this.getLayerEventMask();
        this.eventMask = l;
        this.firePropertyChange("layerEventMask", l2, l);
    }

    @Override
    public void addLayerItemListener(LayerItemListener layerItemListener) {
        this.layerChangeSupport.addLayerItemListener(layerItemListener);
    }

    @Override
    public LayerItemListener[] getLayerItemListeners() {
        return this.layerChangeSupport.getLayerItemListeners();
    }

    @Override
    public void removeLayerItemListener(LayerItemListener layerItemListener) {
        this.layerChangeSupport.removeLayerItemListener(layerItemListener);
    }

    protected void fireLayerItemChanged() {
        this.layerChangeSupport.fireLayerItemChanged();
    }

    protected void fireLayerItemChanged(LayerItemChangeEvent layerItemChangeEvent) {
        this.layerChangeSupport.fireLayerItemChanged(layerItemChangeEvent);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.propertyChangeSupport.getPropertyChangeListeners(string);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        this.enabled = bl;
        this.firePropertyChange("enabled", bl2, bl);
        if (bl2 != bl) {
            this.fireLayerItemChanged();
        }
    }

    protected boolean isDirty() {
        return this.isDirty;
    }

    protected void setDirty(boolean bl) {
        boolean bl2 = this.isDirty();
        this.isDirty = bl;
        if (bl && !bl2) {
            this.fireLayerItemChanged();
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        JXLayer jXLayer = (JXLayer)jComponent;
        this.configureGraphics(graphics2D, jXLayer);
        this.paintLayer(graphics2D, jXLayer);
        this.setDirty(false);
    }

    protected void paintLayer(Graphics2D graphics2D, JXLayer<V> jXLayer) {
        jXLayer.paint(graphics2D);
    }

    protected void configureGraphics(Graphics2D graphics2D, JXLayer<V> jXLayer) {
        Map<RenderingHints.Key, Object> map;
        AffineTransform affineTransform;
        Shape shape;
        Composite composite = this.getComposite(jXLayer);
        if (composite != null) {
            graphics2D.setComposite(composite);
        }
        if ((shape = this.getClip(jXLayer)) != null) {
            graphics2D.clip(shape);
        }
        if ((affineTransform = this.getTransform(jXLayer)) != null) {
            graphics2D.transform(affineTransform);
        }
        if ((map = this.getRenderingHints(jXLayer)) != null) {
            for (RenderingHints.Key key : map.keySet()) {
                Object object = map.get(key);
                if (object == null) continue;
                graphics2D.setRenderingHint(key, map.get(key));
            }
        }
    }

    protected Composite getComposite(JXLayer<V> jXLayer) {
        return null;
    }

    protected AffineTransform getTransform(JXLayer<V> jXLayer) {
        return null;
    }

    protected Shape getClip(JXLayer<V> jXLayer) {
        return null;
    }

    protected Map<RenderingHints.Key, Object> getRenderingHints(JXLayer<V> jXLayer) {
        return emptyRenderingHintMap;
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent, JXLayer<V> jXLayer) {
        if (aWTEvent instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)aWTEvent, jXLayer);
        } else if (aWTEvent instanceof MouseEvent) {
            switch (aWTEvent.getID()) {
                case 500: 
                case 501: 
                case 502: 
                case 504: 
                case 505: {
                    this.processMouseEvent((MouseEvent)aWTEvent, jXLayer);
                    break;
                }
                case 503: 
                case 506: {
                    this.processMouseMotionEvent((MouseEvent)aWTEvent, jXLayer);
                    break;
                }
                case 507: {
                    this.processMouseWheelEvent((MouseWheelEvent)aWTEvent, jXLayer);
                }
            }
        } else if (aWTEvent instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)aWTEvent, jXLayer);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent, JXLayer<V> jXLayer) {
    }

    protected void processMouseEvent(MouseEvent mouseEvent, JXLayer<V> jXLayer) {
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent, JXLayer<V> jXLayer) {
    }

    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent, JXLayer<V> jXLayer) {
    }

    protected void processKeyEvent(KeyEvent keyEvent, JXLayer<V> jXLayer) {
    }

    private static class LayerEventController
    implements AWTEventListener {
        private WeakHashMap<Component, Long> layerMap = new WeakHashMap();
        private boolean isAWTEventListenerAdded;
        private long currentEventMask;

        private LayerEventController() {
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            Object object = aWTEvent.getSource();
            if (object instanceof Component) {
                if (this.layerMap.isEmpty()) {
                    this.removeAWTEventListener();
                } else {
                    for (Component component = (Component)object; component != null; component = component.getParent()) {
                        JXLayer jXLayer;
                        if (!(component instanceof JXLayer) || !this.layerMap.containsKey(jXLayer = (JXLayer)component) || jXLayer.getUI() == null || !jXLayer.getUI().isEnabled() || !jXLayer.getUI().isEventEnabled(aWTEvent.getID())) continue;
                        jXLayer.getUI().eventDispatched(aWTEvent, jXLayer);
                    }
                }
            }
        }

        public void register(Component component, long l) {
            if (component == null) {
                throw new IllegalArgumentException("Layer is null");
            }
            if (l != 0L) {
                this.layerMap.put(component, l);
                if ((l & this.getCurrentEventMask()) != l) {
                    this.updateAWTEventListener();
                }
            }
        }

        private void updateAWTEventListener() {
            if (this.isAWTEventListenerAdded()) {
                this.removeAWTEventListener();
            }
            if (!this.layerMap.isEmpty()) {
                long l = 0L;
                for (Long l2 : this.layerMap.values()) {
                    l |= l2.longValue();
                }
                this.addAWTEventListener(l);
            }
        }

        public void unregister(Component component) {
            if (component == null) {
                throw new IllegalArgumentException("Layer is null");
            }
            Long l = this.layerMap.remove(component);
            if (l != null) {
                this.updateAWTEventListener();
            }
        }

        private long getCurrentEventMask() {
            return this.currentEventMask;
        }

        public boolean isAWTEventListenerAdded() {
            return this.isAWTEventListenerAdded;
        }

        private void addAWTEventListener(long l) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, l);
            this.currentEventMask = l;
            this.isAWTEventListenerAdded = true;
        }

        private void removeAWTEventListener() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            this.isAWTEventListenerAdded = false;
        }
    }
}

