% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fy_year.R
\name{is_fy}
\alias{is_fy}
\alias{fy.year}
\alias{yr2fy}
\alias{fy2yr}
\alias{fy2date}
\alias{date2fy}
\alias{.yr2fy}
\alias{qtr2fy}
\title{Convenience functions for dealing with financial years}
\usage{
yr2fy(yr_ending, assume1901_2100 = .getOption("fy.assume1901_2100",
  .getOption("grattan.assume1901_2100", TRUE)))

.yr2fy(yr_ending)

fy2yr(x, na_error = TRUE)

fy2date(x, na_error = TRUE)

date2fy(date)

qtr2fy(yq)
}
\arguments{
\item{yr_ending}{An integer representing a year.}

\item{assume1901_2100}{For \code{yr2fy}, assume that \code{yr_ending} is between 1901 and 2100,
for performance. By default, set to \code{getOption("fy.assume1901_2100", TRUE)}.}

\item{x, fy.yr}{A character vector suspected to be a financial year.}

\item{na_error}{If an input expects a financial year and \code{na_error} is \code{TRUE}
then the function exits with an error.}

\item{date}{A string or date for which the financial year is desired. Note that \code{yr2fy} does not check its argument is an integer.}

\item{yq}{A character vector representing year quarters in \code{1066-Q2} format.}
}
\value{
For \code{is_fy}, a logical, whether its argument is a financial year.
The following forms are allowed: \code{2012-13}, \code{201213}, \code{2012 13}, only.
For \code{fy.year}, \code{yr2fy}, and \code{date2fy}, the financial year.
For the inverses, a numeric corresponding to the year.

\code{fy.year} is a deprecated alias for \code{yr2fy}, the latter is slightly more efficient, as well as more declarative.

\code{fy2yr} converts a financial year to the year ending: \code{fy2yr("2016-17")} returns 2017. \code{yr2fy} is the inverse: \code{yr2fy(fy2yr("2016-17")) == "2016-17"}.

\code{fy2date} converts a financial year to the 30 June of the financial year ending.

\code{date2fy} converts a date to the corresponding financial year.
}
\description{
Convenience functions for dealing with financial years
}
\details{
The following forms are permitted: \code{2012-13}, \code{201213}, \code{2012 13}, only.
However, the \code{2012-13} form is preferred and will improve performance.
}
\examples{
is_fy("2012-13")
is_fy("2012-14")
yr2fy(2012)
fy2yr("2015-16")
date2fy("2014-08-09")
}
