% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_algo2.R
\name{boot_algo2}
\alias{boot_algo2}
\title{Fast wild cluster bootstrap algorithm}
\usage{
boot_algo2(
  preprocessed_object,
  boot_iter,
  wild_draw_fun,
  point_estimate,
  impose_null,
  beta0,
  sign_level,
  param,
  seed,
  p_val_type,
  nthreads
)
}
\arguments{
\item{preprocessed_object}{A list: output of the preprocess2 function.}

\item{boot_iter}{number of bootstrap iterations}

\item{wild_draw_fun}{function. Specifies the type of bootstrap to use.}

\item{point_estimate}{The point estimate of the test parameter from the regression model.}

\item{impose_null}{If TRUE, the null is not imposed on the bootstrap distribution.
This is what Roodman et al call the "WCU" bootstrap. With impose_null = FALSE, the
null is imposed ("WCR").}

\item{beta0}{Shifts the null hypothesis.}

\item{sign_level}{The significance level.}

\item{param}{name of the test parameter.}

\item{seed}{the random seed. controls draw of bootstrap weights.}

\item{p_val_type}{type Type of p-value. By default "two-tailed". Other options: "equal-tailed", ">", "<"}

\item{nthreads}{The number of threads. Can be: a) an integer lower than,
or equal to, the maximum number of threads; b) 0: meaning
all available threads will be used; c) a number strictly
between 0 and 1 which represents the fraction of all threads
to use. The default is to use 50\\% of all threads. You can
set permanently the number of threads used within this
package using the function ...}
}
\value{
A list of ...
}
\description{
function that implements the fast bootstrap algorithm as described in Roodman et al (2019)
}
