% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fusionCustomAxis.R
\name{fusionCustomAxis}
\alias{fusionCustomAxis}
\title{Customing FusionCharts axis}
\usage{
fusionCustomAxis(
  fusionPlot,
  xAxisPosition = c("bottom", "top", "left", "right"),
  yAxisPosition = c("left", "right", "top", "bottom"),
  AxisNameBorderColor = NULL,
  AxisNameBorderAlpha = "0",
  AxisNameBorderPadding = "6",
  AxisNameBorderRadius = "3",
  AxisNameBorderThickness = "2",
  AxisNameBorderDashed = FALSE,
  AxisNameBorderDashLen = "4",
  AxisNameBorderDashGap = "2",
  AxisNameBgColor = NULL,
  AxisNameBgAlpha = "0",
  AxisNameFontAlpha = "100",
  AxisValueFont = "Arial",
  AxisValueFontSize = "1px",
  AxisValueFontColor = NULL,
  AxisValueFontBold = FALSE,
  AxisValueFontItalic = FALSE,
  AxisValueAlpha = "100",
  AxisValueBgColor = NULL,
  AxisValueBgAlpha = "50",
  AxisValueBorderColor = "#ffffff",
  AxisValueBorderAlpha = "0",
  AxisValueBorderPadding = "5",
  AxisValueBorderRadius = "2",
  AxisValueBorderThickness = "3",
  AxisValueBorderDashed = FALSE,
  AxisValueBorderDashLen = "2",
  AxisValueBorderDashGap = "2"
)
}
\arguments{
\item{fusionPlot}{fusionPlot object got by \code{fusionPlot()}}

\item{xAxisPosition}{change the position of the x-axis}

\item{yAxisPosition}{change the position of the y-axis}

\item{AxisNameBorderColor}{Set the border color of the name of the axis}

\item{AxisNameBorderAlpha}{Set the transparency of the border around the name of axis}

\item{AxisNameBorderPadding}{Set the padding of the border around the name of the axis}

\item{AxisNameBorderRadius}{Set the radius of the border around the name of the axis}

\item{AxisNameBorderThickness}{Set the thickness of the border around the name of the axis}

\item{AxisNameBorderDashed}{Make the border around the name of the axis dashed}

\item{AxisNameBorderDashLen}{Set the length of each dash in the dashed border around the name of the axis}

\item{AxisNameBorderDashGap}{Set the gap between two consecutive dashes in the dashed border around the name of the axis}

\item{AxisNameBgColor}{Set the background color of the name of the axis}

\item{AxisNameBgAlpha}{Set the transparency of the background of the name of the axis}

\item{AxisNameFontAlpha}{Set the transparency of the name of the axis}

\item{AxisValueFont}{Set the font of the axis values}

\item{AxisValueFontSize}{Set the font size (between 0 to 72) of the axis values}

\item{AxisValueFontColor}{Set the font color of the axis}

\item{AxisValueFontBold}{Set the font of the axis values to bold}

\item{AxisValueFontItalic}{Set the font for the axis values to italics}

\item{AxisValueAlpha}{Set the degree of transparency of the axis values}

\item{AxisValueBgColor}{Set the background color of the axis values}

\item{AxisValueBgAlpha}{Set the background color transparency of the axis values}

\item{AxisValueBorderColor}{Set the border color of the axis values}

\item{AxisValueBorderAlpha}{Set the transparency of the border of the axis values}

\item{AxisValueBorderPadding}{Set the padding of the axis values border}

\item{AxisValueBorderRadius}{Set the border radius of the axis values}

\item{AxisValueBorderThickness}{Set the border thickness of the axis values}

\item{AxisValueBorderDashed}{Make the axis values border dashed}

\item{AxisValueBorderDashLen}{Set the length of each dash for the dashed borders around axis values}

\item{AxisValueBorderDashGap}{Set the gap between two consecutive dashes for the dashed borders around the axis values}
}
\description{
\url{https://www.fusioncharts.com/dev/chart-guide/chart-configurations/axes}
}
\examples{
library(fusionchartsR)

df <- data.frame(label = c("Venezuela", "Saudi", "Canada", "Russia"), value = c(290, 260,180, 115))
fusionPlot(data = df, type = "column3d") \%>\%
  fusionAxis(xAxisName = "Countries", yAxisName = "Numbers", AxisNameFontSize = "20") \%>\%
  fusionCustomAxis(xAxisPosition = "top", yAxisPosition = "right") \%>\%
  fusionTheme(theme = "gammel")

}
