% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Any.R
\name{Any}
\alias{Any}
\title{Test if any items in an object evaluate to TRUE.}
\usage{
Any(f, x, ..., na.rm = FALSE)
}
\arguments{
\item{f}{a predicate function.}

\item{x}{an iterable object.}

\item{...}{further arguments passed to the predicate function.}

\item{na.rm}{a logical value indicating whether NA values should be stripped before the computation proceeds.}
}
\value{
a logical value.
}
\description{
\code{Any()} is a predicate functional that takes a predicate function
\code{f} and an iterable object \code{x} and:
\enumerate{
  \item iterates over each item \code{i} in object \code{x},
  \item evaluates \code{f(i)},
  \item and ultimately returns TRUE if any items \code{i} in object \code{x} evaluate as TRUE.
  }
}
\examples{
# Examples
data(mtcars)
Any(is.numeric, mtcars) # TRUE
Any(is.character, mtcars) # FALSE
mtcars$am <- factor(mtcars$am)
Any(is.numeric, mtcars) # TRUE
Any(is.factor, mtcars) # TRUE

# Handles NAs and NULLs
Any(is.numeric, list(NA, "3", NULL)) # FALSE
Any(is.numeric, list(NA, 3, NULL)) # TRUE
Any(is.numeric, list(NA, "3", NULL, 5)) #TRUE

# Use na.rm = TRUE to remove NULLS
Any(Identity, list(NA, FALSE)) # NA
Any(Identity, list(NA, FALSE), na.rm = TRUE) # FALSE
}
\seealso{
\code{\link{All}} to test if all items in an object evaluate to TRUE.

Other predicate functionals: \code{\link{All}};
  \code{\link{Reject}}
}

