% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_fclust.R
\name{ftest_plot_performances}
\alias{ftest_plot_performances}
\title{Plot the evaluation of weight of each performance
  on functional clustering}
\usage{
ftest_plot_performances(fres, rtest,
                        main = "Title", opt.crit = "Jaccard", opt.perf = NULL)
}
\arguments{
\item{fres}{an object resulting from a functional clustering
obtained with the whole dataset using the function \code{\link{fclust}}.}

\item{rtest}{a list of matrices,
each containing the results for a clustering index.
\code{rtest} is an object generated by the function \code{ftest}.}

\item{main}{a string, that is used
as the first, reference part of the title of each graph.}

\item{opt.crit}{a list of strings,
indicating the clustering indices to plot.
The indices can be:
 "Czekanowski_Dice", "Folkes_Mallows", "Jaccard", "Kulczynski",
 "Precision", "Rand", "Recall", "Rogers_Tanimoto", "Russel_Rao",
 "Sokal_Sneath1" or "Sokal_Sneath2".
 For more informations, see the notice of R-package \code{clusterCrit}.}

\item{opt.perf}{a list, that can include
a list, that can include
\code{opt.comp} = \code{list("all.together", "performances.together",
 "sorted.leg")}.
This option list manages the plot
of results obtained using the function \code{ftest}
with \code{opt.var = "performances"}.
The item order in list is any.

\itemize{
 \item{\code{"all.together", "performances.together"}}
   {  plot \emph{(i)} the general mean index;
   \emph{(ii)} the mean indices for each removed performance on a same plot,
   when removing one after one each performance from the dataset.
   This allows to evaluate the raw robustness of functional clustering
   to perturbation of dataset,
   and the weight of each performance on functional clustering.
   }

\item{\code{"sorted.leg"}}{  plot
  the names of performances decreasingly sorted
  according to their weight on functional clustering.
  }

\item{\code{"all"}}{  plot all possible graphs.
  This option is equivalent to
  \code{opt.comp} = \code{list("all.together", "performances.together",
 "sorted.leg")}.
  }
}}
}
\value{
Nothing. It is a procedure.
}
\description{
Evaluate by cross-validation (leave-one-out)
 the effect induced by leaving out each performance
 on the result of a functional clustering.
}
\details{
The trees obtained by leaving out each performance
are compared to the reference tree obtained with all performances
using different criteria :
"Czekanowski_Dice", "Folkes_Mallows", "Jaccard", "Kulczynski",
 "Precision", "Rand", "Recall", "Rogers_Tanimoto", "Russel_Rao",
 "Sokal_Sneath1" and "Sokal_Sneath2" index.
 For more informations, see the notice of R-package \code{clusterCrit}.
}
\references{
Package "clusterCrit": Clustering Indices,
  by Bernard Desgraupes (University of Paris Ouest - Lab Modal'X)
}
\keyword{internal}
