% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models_lib.R
\name{model_performance}
\alias{model_performance}
\title{Get model perfomance metrics (KS, AUC and ROC)}
\usage{
model_performance(fit, data, target_var)
}
\arguments{
\item{fit}{model, it could be any of the following: decision tree from rpart package, glm model or randomForest.}

\item{data}{data frame used to build the model. Also it supports data for testing, (it has to contain same columns as training data.}

\item{target_var}{It's the name of the column used as target/outcome. It's an string value, write it between apostrohpe.}
}
\value{
None.
}
\description{
Get model performance for tree models (rpart library), or glm. It returns quality metrics: AUC (Area Under ROC Curve) and KS (Kolmogorov-Smirnov), and plots the ROC curve.
}
\examples{
fit_glm=glm(has_heart_disease ~ age + oldpeak, data=heart_disease, family = binomial)
model_performance(fit=fit_glm, data = heart_disease, target_var = "has_heart_disease")
}

