% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bayesian_plot.R
\name{bayesian_plot}
\alias{bayesian_plot}
\title{Cross-plotting input variable vs. target variable}
\usage{
bayesian_plot(data, input, target, title = "Bayesian comparison",
  plot_all = F, extra_above = 5, extra_under = 5, path_out)
}
\arguments{
\item{data}{data frame source}

\item{input}{string input variable (if empty, it runs for all variables), it can take a single character value or a character vector.}

\item{target}{string of the variable to predict}

\item{title}{Plot title}

\item{plot_all}{By default, if there are more than 10 unique values, the plot will only show the top and bottom 5 values, and conglomerate the rest in "Other categories".}

\item{extra_above}{How many of the most likely occurrences to plot above}

\item{extra_under}{How many of the least likely occurrences to plot above}

\item{path_out}{path directory, if it has a value the plot is saved}
}
\value{
bayesian plot
}
\description{
The bayesian_plot shows how the input variable is correlated with the target variable, comparing with a bayesian approach the posterior conversion rate to the target variable. It's useful to compare categorical values, which have no intrinsic ordering. If they have instrinsic ordering, cross_plot can be used instead.
}
\examples{
\dontrun{
## Example 1:
bayesian_plot(data=heart_disease, input="chest_pain", target="has_heart_disease")

## Example 2: Saving the plot into a folder:
bayesian_plot(data=heart_disease, input="oldpeak",
		target="has_heart_disease", path_out = "my_folder")

## Example 3: Running with multiple input variables at the same time:
bayesian_plot(data=heart_disease, input=c("gender", "age"),
		target="has_heart_disease", path_out = ".")
}
}

