% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funDataMethods.R
\name{expand.int}
\alias{expand.int}
\title{Function to expand integers to a grid of indices}
\usage{
expand.int(...)
}
\arguments{
\item{...}{An arbitrary number of integer values.}
}
\value{
A dataframe with the same number of columns as integers supplied and containing all 
  combinations of indices from 1 to the given integers. If no number is supplied, the function
  returns \code{NULL}.
}
\description{
This function takes an arbitrary number \eqn{K} of integer values \eqn{n_1,\ldots, n_K} and 
creates a data frame with all combinations from \code{1:}\eqn{n_k}, where the first column 
(taking values from 1 to \eqn{n_1}) varies slowest and the last column (())taking values from 1 
to \eqn{n_K}) varies fastest. Internally, this function depends on \code{\link{expand.grid}}
}
\examples{
# For two integers
funData:::expand.int(2,5) # first column varies slowest

# For three integers
funData:::expand.int(2,3,4)
}
\keyword{internal}
