% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bmc_utils.R
\name{bmc_xml}
\alias{bmc_xml}
\title{Download full text xml of a BMC paper.}
\usage{
bmc_xml(obj = NULL, uris = NULL, dir = NULL, raw = FALSE, ...)
}
\arguments{
\item{obj}{(optional) An object of class bmc, from a call to \code{bmc_search}}

\item{uris}{(optional) A uri to a xml file of a BMC paper}

\item{dir}{(optional) A directory to save to. The file extension is forced to
.xml, and the file name will be}

\item{raw}{(logical) If TRUE, returns raw text, but if FALSE, parsed XML. Default: FALSE}

\item{...}{Futher args passed on to \code{\link[httr]{GET}} for debugging curl calls.}
}
\description{
Download full text xml of a BMC paper.
}
\examples{
\dontrun{
uri = 'http://www.biomedcentral.com/content/download/xml/1471-2393-14-71.xml'
uri = 'http://www.springerplus.com/content/download/xml/2193-1801-3-7.xml'
uri = 'http://www.microbiomejournal.com/content/download/xml/2049-2618-2-7.xml'
bmc_xml(uris=uri)
bmc_xml(uris=uri, dir='~/')
bmc_xml(uris=uri, verbose())

# from using bmc_search
out <- bmc_search(terms = 'science', limit=5)
dat <- bmc_xml(out)
length(dat)
dat <- Filter(Negate(is.null), dat)
length(dat)
dat

# curl debugging, and other parameters passed to httr::GET()
uri = 'http://www.microbiomejournal.com/content/download/xml/2049-2618-2-7.xml'
res <- bmc_xml(uris=uri, config=verbose())
# res <- bmc_xml(uris=uri, config=timeout(0.1))

uri1 = 'http://www.biomedcentral.com/content/download/xml/1471-2393-14-71.xml'
uri2 = 'http://www.springerplus.com/content/download/xml/2193-1801-3-7.xml'
uri3 = 'http://www.microbiomejournal.com/content/download/xml/2049-2618-2-7.xml'
res <- bmc_xml(uris=list(uri1, uri2, uri3), config=progress())
}
}
\keyword{internal}

