\name{plot.fmres}
\alias{plot.fmres}
\title{Plot residuals from a fitted functional model.}
\description{
Functions to produce a plot of residuals from a fitted functional model.
}
\usage{
plot.fmres(x, type = c("image", "fts", "contour", "filled.contour", 
 "persp"), xlab = "Year", ylab = "Age", zlab = "Residual", ...)
}
\arguments{
\item{x}{Generated by \code{residuals(fit)}, where fit is the output from \code{\link[ftsa]{ftsm}} or \code{\link[ftsa]{fplsr}}.}
\item{type}{Type of plot to use. Possibilities are \code{\link[graphics]{image}}, \code{fts}, 
    \code{\link[graphics]{contour}}, \code{\link[graphics]{filled.contour}} and \code{\link[graphics]{persp}}.}
\item{xlab}{Label for \code{x}-axis.}
\item{ylab}{Label for \code{y}-axis.}
\item{zlab}{Label for \code{z}-axis.}
\item{...}{Plotting parameters.}
}
\value{
Produces a plot.
}
\author{Rob J Hyndman}
\seealso{\code{\link[ftsa]{ftsm}}, \code{\link[ftsa]{forecast.ftsm}}, \code{\link[ftsa]{plot.fm}}, \code{\link[ftsa]{plot.fmres}}, \code{\link[ftsa]{residuals.fm}}, \code{\link[ftsa]{summary.fm}}}
\examples{
plot(residuals(ftsm(ElNino)), type = "filled.contour", xlab = "Month", 
     ylab = "Residual sea surface temperature")
}
\keyword{hplot}
