% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fst.R
\name{fst.metadata}
\alias{fst.metadata}
\title{Read metadata from a fst file}
\usage{
fst.metadata(path)
}
\arguments{
\item{path}{Path to fst file}
}
\value{
Returns A list with meta information on the stored dataset in \code{path}. Has class 'fst.metadata'.
}
\description{
Method for checking basic properties of the dataset stored in \code{path}.
}
\examples{
# Sample dataset
x <- data.frame(
  First = 1:10,
  Second = sample(c(TRUE, FALSE, NA), 10, replace = TRUE),
  Last = sample(LETTERS, 10))

# Write to fst file
write.fst(x, "dataset.fst")

# Display meta information
fst.metadata("dataset.fst")
}

